/*
 * Decompiled with CFR 0.152.
 */
package net.murakamin.csv;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import net.murakamin.csv.CSVHeader;
import net.murakamin.csv.exception.CSVWriteException;
import org.apache.commons.lang.SystemUtils;

public class CSVWriter {
    private static char DEFAULT_FIELD_SEPARATOR = (char)44;
    private static String DEFAULT_FILE_ENCODING = SystemUtils.FILE_ENCODING;
    public static char QUOTE_NONE = '\u0000';
    private int currentLineNo = 1;
    private String encoding = DEFAULT_FILE_ENCODING;
    private char fieldSeparator = DEFAULT_FIELD_SEPARATOR;
    private CSVHeader header;
    private boolean overwrite = false;
    private char quoteChar = QUOTE_NONE;
    private boolean supportHeader = false;
    private BufferedOutputStream writer;

    public void close() throws IOException {
        this.writer.close();
    }

    private String createDataLine(String[] datas) throws UnsupportedEncodingException {
        StringBuffer buffer = new StringBuffer();
        int maxColumns = datas.length;
        int c = 0;
        while (c < maxColumns) {
            if (datas[c] != null) {
                if (this.getQuoteChar() != QUOTE_NONE) {
                    datas[c] = datas[c].replaceAll("\"", "\"\"");
                }
                if (this.getQuoteChar() != QUOTE_NONE && this.header != null) {
                    Class<? extends Object> dataType = this.header.get(c).getType();
                    if (dataType == String.class || dataType == Date.class || dataType == Time.class || dataType == Timestamp.class || dataType == Character.class) {
                        buffer.append(this.getQuoteChar());
                        buffer.append(datas[c]);
                        buffer.append(this.getQuoteChar());
                    } else {
                        buffer.append(datas[c]);
                    }
                } else {
                    buffer.append(datas[c]);
                }
            }
            if (c < maxColumns - 1) {
                buffer.append(this.getFieldSeparator());
            }
            ++c;
        }
        buffer.append(SystemUtils.LINE_SEPARATOR);
        return buffer.toString();
    }

    private String createHeaderLine() throws UnsupportedEncodingException {
        if (!this.isSupportHeader()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int maxColumns = this.header.size();
        int c = 0;
        while (c < maxColumns) {
            buffer.append(this.header.get(c).getName());
            if (c < maxColumns - 1) {
                buffer.append(this.getFieldSeparator());
            }
            ++c;
        }
        buffer.append(SystemUtils.LINE_SEPARATOR);
        return buffer.toString();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public char getFieldSeparator() {
        return this.fieldSeparator;
    }

    public char getQuoteChar() {
        return this.quoteChar;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean isSupportHeader() {
        return this.supportHeader;
    }

    public void open(File target) throws IOException {
        if (target.exists()) {
            if (this.isOverwrite()) {
                target.delete();
            } else {
                throw new CSVWriteException("The file already exists : " + target);
            }
        }
        this.writer = new BufferedOutputStream(new FileOutputStream(target));
        if (this.isSupportHeader()) {
            this.writer.write(this.createHeaderLine().getBytes(this.getEncoding()));
        }
    }

    public void open(File target, boolean overwrite) throws IOException {
        this.setOverwrite(overwrite);
        this.open(target);
    }

    public void open(File target, CSVHeader header) throws IOException {
        this.header = header;
        this.open(target);
    }

    public void open(File target, CSVHeader header, boolean overwrite) throws IOException {
        this.header = header;
        this.open(target, overwrite);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setFieldSeparator(char fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setQuoteChar(char quoteChar) {
        this.quoteChar = quoteChar;
    }

    public void setSupportHeader(boolean supportHeader) {
        this.supportHeader = supportHeader;
    }

    public void write(String[] datas) throws CSVWriteException {
        try {
            ++this.currentLineNo;
            this.writer.write(this.createDataLine(datas).getBytes(this.getEncoding()));
        }
        catch (IOException e) {
            throw new CSVWriteException(this.currentLineNo, (Throwable)e);
        }
    }
}

