/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor;

import java.text.DecimalFormat;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.DoubleCellProcessor;
import org.supercsv.cellprocessor.ift.LongCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.ClassCastInputCSVException;
import org.supercsv.exception.NullInputException;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.util.CSVContext;

public class FmtNumber
extends CellProcessorAdaptor
implements DoubleCellProcessor,
LongCellProcessor {
    protected DecimalFormat formatter;

    public FmtNumber(String string) {
        this(new DecimalFormat(string));
    }

    public FmtNumber(String string, StringCellProcessor stringCellProcessor) {
        this(new DecimalFormat(string), stringCellProcessor);
    }

    public FmtNumber(DecimalFormat decimalFormat) {
        this.formatter = decimalFormat;
    }

    public FmtNumber(DecimalFormat decimalFormat, StringCellProcessor stringCellProcessor) {
        super(stringCellProcessor);
        this.formatter = decimalFormat;
    }

    public Object execute(Object object, CSVContext cSVContext) throws SuperCSVException {
        if (object == null) {
            throw new NullInputException("Input cannot be null on line " + cSVContext.lineNumber + " column " + cSVContext.columnNumber, cSVContext, this);
        }
        if (!(object instanceof Number)) {
            throw new ClassCastInputCSVException("the value '" + object + "' is not of type Number", cSVContext, this);
        }
        String string = this.formatter.format(object);
        return this.next.execute(string, cSVContext);
    }
}

