/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor;

import java.util.Map;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.BoolCellProcessor;
import org.supercsv.cellprocessor.ift.DateCellProcessor;
import org.supercsv.cellprocessor.ift.DoubleCellProcessor;
import org.supercsv.cellprocessor.ift.LongCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.NullInputException;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.util.CSVContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMapper
extends CellProcessorAdaptor
implements BoolCellProcessor,
DateCellProcessor,
DoubleCellProcessor,
LongCellProcessor,
StringCellProcessor {
    private final Map<Object, Object> mapping;
    private final Object defaultValue;

    public HashMapper(Map<Object, Object> map) {
        this.mapping = map;
        this.defaultValue = null;
    }

    public HashMapper(Map<Object, Object> map, Object object) {
        this.mapping = map;
        this.defaultValue = object;
    }

    public HashMapper(Map<Object, Object> map, BoolCellProcessor boolCellProcessor) {
        this(map, null, boolCellProcessor);
    }

    public HashMapper(Map<Object, Object> map, Object object, BoolCellProcessor boolCellProcessor) {
        super(boolCellProcessor);
        this.mapping = map;
        this.defaultValue = object;
        if (map == null) {
            throw new NullInputException("Mapping cannot be null", this);
        }
    }

    @Override
    public Object execute(Object object, CSVContext cSVContext) throws SuperCSVException {
        if (object == null) {
            throw new NullInputException("Input cannot be null on line " + cSVContext.lineNumber + " at column " + cSVContext.columnNumber, cSVContext, this);
        }
        Object object2 = this.mapping.get(object);
        if (object2 == null) {
            object2 = this.defaultValue;
        }
        return this.next.execute(object2, cSVContext);
    }
}

