/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor;

import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.BoolCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.NullInputException;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.util.CSVContext;

public class ParseBool
extends CellProcessorAdaptor
implements StringCellProcessor {
    private static String[] DEFAULT_TRUE_VALUES = new String[]{"1", "true", "t", "y"};
    private static String[] DEFAULT_FALSE_VALUES = new String[]{"0", "false", "f", "n"};
    private final String[] trueValues;
    private final String[] falseValues;

    public ParseBool() {
        this(DEFAULT_TRUE_VALUES, DEFAULT_FALSE_VALUES);
    }

    public ParseBool(BoolCellProcessor boolCellProcessor) {
        this(DEFAULT_TRUE_VALUES, DEFAULT_FALSE_VALUES, boolCellProcessor);
    }

    public ParseBool(String string, String string2) {
        this.trueValues = new String[]{string};
        this.falseValues = new String[]{string2};
    }

    public ParseBool(String[] stringArray, String[] stringArray2) {
        this.trueValues = stringArray;
        this.falseValues = stringArray2;
    }

    public ParseBool(String string, String string2, BoolCellProcessor boolCellProcessor) {
        super(boolCellProcessor);
        this.trueValues = new String[]{string};
        this.falseValues = new String[]{string2};
    }

    public ParseBool(String[] stringArray, String[] stringArray2, BoolCellProcessor boolCellProcessor) {
        super(boolCellProcessor);
        this.trueValues = stringArray;
        this.falseValues = stringArray2;
    }

    public Object execute(Object object, CSVContext cSVContext) throws SuperCSVException {
        Boolean bl;
        if (object == null) {
            throw new NullInputException("Input cannot be null on line " + cSVContext.lineNumber + " column " + cSVContext.columnNumber, cSVContext, this);
        }
        String string = ((String)object).toLowerCase();
        if (this.isFalseValue(string)) {
            bl = Boolean.FALSE;
        } else if (this.isTrueValue(string)) {
            bl = Boolean.TRUE;
        } else {
            throw new SuperCSVException("Cannot parse \"" + object + "\" to a boolean on line " + cSVContext.lineNumber + " column " + cSVContext.columnNumber, cSVContext, this);
        }
        return this.next.execute(bl, cSVContext);
    }

    private boolean isTrueValue(String string) {
        return ParseBool.indexOf(string, this.trueValues) >= 0;
    }

    private boolean isFalseValue(String string) {
        return ParseBool.indexOf(string, this.falseValues) >= 0;
    }

    private static int indexOf(String string, String[] stringArray) {
        if (stringArray == null) {
            return -1;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return i;
        }
        return -1;
    }
}

