/*
 * Decompiled with CFR 0.152.
 */
package net.murakamin.sticker.commands;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import net.murakamin.sticker.CommandRunner;
import net.murakamin.sticker.Commands;
import net.murakamin.sticker.ConnectionPool;
import net.murakamin.sticker.StickerContext;
import net.murakamin.sticker.commands.CursorCommand;
import net.murakamin.sticker.commands.ExecutableCommand;
import net.murakamin.sticker.commands.Messages;
import net.murakamin.sticker.commands.ParentCommand;
import net.murakamin.sticker.commands.VersionTerm;
import net.murakamin.sticker.commands.enums.PostChildCommandExecutionType;
import net.murakamin.sticker.commands.enums.PreChildCommandExecutionType;
import net.murakamin.sticker.commands.enums.TargetType;
import net.murakamin.sticker.commands.exception.CommandExecutionException;

public class ForCommand
implements ParentCommand {
    Commands childlen = new Commands();
    private TargetType target = TargetType.remote;
    private String name;
    private Statement cursorStatement = null;
    private ResultSet cursorRecordSet = null;

    @Override
    public void addChild(ExecutableCommand child) {
        this.childlen.add(child);
    }

    @Override
    public void execute(CommandRunner runner) throws Exception {
        ConnectionPool pool = runner.getConnectionPool();
        StickerContext context = runner.getStickerContext();
        Connection con = pool.getLocalConnection();
        CursorCommand cursor = (CursorCommand)context.get(String.valueOf(CursorCommand.CURSOR_NAME_PREFIX) + this.getName());
        if (cursor == null) {
            throw new CommandExecutionException(String.valueOf(Messages.getString("net.murakamin.sticker.commands.CursorCommand.Corsor_not_found")) + this.getName());
        }
        if (this.target == TargetType.remote) {
            con = pool.getRemoteConnection();
        }
        try {
            this.cursorStatement = con.createStatement();
            this.cursorRecordSet = this.cursorStatement.executeQuery(cursor.getSql());
        }
        catch (Exception e) {
            if (this.cursorStatement != null) {
                this.cursorStatement.close();
            }
            if (this.cursorRecordSet != null) {
                this.cursorRecordSet.close();
            }
            this.cursorRecordSet = null;
        }
        if (this.cursorRecordSet == null) {
            throw new CommandExecutionException((ExecutableCommand)this, String.valueOf(Messages.getString("net.murakamin.sticker.commands.CursorCommand.Cursor_open_failure")) + this.getName());
        }
        runner.run(this);
    }

    @Override
    public Commands getChildlen() {
        return this.childlen;
    }

    public String getName() {
        return this.name;
    }

    public String getTarget() {
        return this.target.name();
    }

    @Override
    public VersionTerm getVersionTerm() {
        return new VersionTerm("0.1.3");
    }

    @Override
    public boolean isDebugPrint() {
        return false;
    }

    @Override
    public PostChildCommandExecutionType postChildCommandExecute(CommandRunner runner) throws Exception {
        boolean last = true;
        if (this.cursorRecordSet != null) {
            this.cursorRecordSet.next();
            last = this.cursorRecordSet.isAfterLast();
        }
        if (last) {
            try {
                if (this.cursorStatement != null) {
                    this.cursorStatement.close();
                }
                if (this.cursorRecordSet != null) {
                    this.cursorRecordSet.close();
                }
            }
            catch (SQLException sQLException) {}
        } else {
            StickerContext context = runner.getStickerContext();
            if (this.cursorRecordSet != null) {
                ResultSetMetaData metaData = this.cursorRecordSet.getMetaData();
                HashMap<String, Object> fieldMap = new HashMap<String, Object>();
                int c = 1;
                while (c <= metaData.getColumnCount()) {
                    fieldMap.put(metaData.getColumnName(c).toUpperCase(), this.cursorRecordSet.getObject(c));
                    ++c;
                }
                context.pushFieldStack(fieldMap);
            }
        }
        return last ? PostChildCommandExecutionType.NOT_REPEAT : PostChildCommandExecutionType.REPEAT_EXECUTE;
    }

    @Override
    public PreChildCommandExecutionType preChildCommandExecute(CommandRunner runner) throws Exception {
        boolean execute = false;
        if (this.cursorRecordSet != null) {
            execute = this.cursorRecordSet.isBeforeFirst();
        }
        if (execute) {
            StickerContext context = runner.getStickerContext();
            ResultSetMetaData metaData = this.cursorRecordSet.getMetaData();
            this.cursorRecordSet.next();
            HashMap<String, Object> fieldMap = new HashMap<String, Object>();
            int c = 1;
            while (c <= metaData.getColumnCount()) {
                fieldMap.put(metaData.getColumnName(c).toUpperCase(), this.cursorRecordSet.getObject(c));
                ++c;
            }
            context.pushFieldStack(fieldMap);
        }
        return execute ? PreChildCommandExecutionType.CHILD_EXECUTE : PreChildCommandExecutionType.CHILD_NOT_EXECUTE;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTarget(String target) {
        this.target = TargetType.valueOf(target);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<For name=\"");
        buffer.append(this.getName());
        buffer.append("\" ");
        buffer.append("target=\"");
        buffer.append(this.getTarget());
        buffer.append("\">");
        return buffer.toString();
    }
}

