/**
 *   Copyright 2007 Y.Murakamin
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package net.murakamin.sticker.commands;

import net.murakamin.sticker.CommandRunner;
import net.murakamin.sticker.Commands;
import net.murakamin.sticker.commands.enums.PostChildCommandExecutionType;
import net.murakamin.sticker.commands.enums.PreChildCommandExecutionType;

/**
 * Command to define cursor tag collectively
 * 
 * @author Y.Murakamin
 * @see net.murakamin.sticker.commands.CursorCommand
 * @since 0.1.3
 */
public class CursorsCommand implements ParentCommand
{

	private final Commands childlen = new Commands();

	/**
	 * @see net.murakamin.sticker.commands.ParentCommand#addChild(ExecutableCommand)
	 */
	public void addChild(final ExecutableCommand child)
	{
		this.childlen.add(child);
	}

	/**
	 * do nothing
	 * 
	 * @see net.murakamin.sticker.commands.ExecutableCommand#execute(CommandRunner)
	 */
	public void execute(final CommandRunner runner) throws Exception
	{
		runner.run(this);
	}

	/**
	 * @see net.murakamin.sticker.commands.ParentCommand#getChildlen()
	 */
	public Commands getChildlen()
	{
		return this.childlen;
	}

	/**
	 * @see net.murakamin.sticker.commands.ExecutableCommand#getVersionTerm()
	 */
	public VersionTerm getVersionTerm()
	{
		return VersionTerm.PERMANENT_COMMAND;
	}

	/**
	 * The log is output in the debugging log.
	 * 
	 * @return always true
	 * @see net.murakamin.sticker.commands.ExecutableCommand#isDebugPrint()
	 */
	public boolean isDebugPrint()
	{
		return true;
	}

	/**
	 * do nothing
	 * 
	 * @return {@link net.murakamin.sticker.commands.enums.PostChildCommandExecutionType.NOT_REPEAT PostChildCommandExecutionType.NOT_REPEAT}
	 * @see net.murakamin.sticker.commands.ParentCommand#postChildCommandExecute(CommandRunner)
	 */
	public PostChildCommandExecutionType postChildCommandExecute(
	        final CommandRunner runner) throws Exception
	{
		return PostChildCommandExecutionType.NOT_REPEAT;
	}

	/**
	 * @return {@link net.murakamin.sticker.commands.enums.PreChildCommandExecutionType.CHILD_EXECUTE PreChildCommandExecutionType.CHILD_EXECUTE}
	 * @see net.murakamin.sticker.commands.ParentCommand#preChildCommandExecute(CommandRunner)
	 */
	public PreChildCommandExecutionType preChildCommandExecute(
	        final CommandRunner runner) throws Exception
	{
		return PreChildCommandExecutionType.CHILD_EXECUTE;
	}

	@Override
	public String toString()
	{
		return "<cursors> cursor definition.";
	}
}
