/**
 *   Copyright 2007 Y.Murakamin
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package net.murakamin.sticker.commands;

/**
 * 
 * Interface that shows data base connection properties
 * 
 * @author Y.Murkaamin
 * @see net.murakamin.sticker.command.ServerCommand
 * 
 */
public interface DatabaseConnectionProperties
{

	/**
	 * get the database charset
	 * 
	 * @return charset name
	 */
	String getCharset();

	/**
	 * get the jdbc driver class fqcn.
	 * 
	 * @return driver class fqcn.
	 */
	String getDriver();

	/**
	 * get the jdbc driver jar file name.
	 * 
	 * @return driver jar file name.
	 */
	String getDriverJarFile();
	
	/**
	 * get the database connection name
	 * 
	 * @return database connection name
	 */
	String getName();

	/**
	 * get the database password
	 * 
	 * @return database password
	 */
	String getPass();

	/**
	 * get the database connection url
	 * 
	 * @return database connection url
	 */
	String getUrl();

	/**
	 * get the database connect user name
	 * 
	 * @return database connect user name
	 */
	String getUser();

	/**
	 * get the auto commit flag
	 * 
	 * @return auto commit mode is true
	 */
	boolean getAutocommit();

}