/*
 * Decompiled with CFR 0.152.
 */
package net.trialpc.sticktools.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.trialpc.sticktools.model.DocumentModel;
import net.trialpc.sticktools.model.StateChangeObservable;
import net.trialpc.sticktools.model.WrapModel;

public class DocCollection<T extends DocumentModel>
extends WrapModel<T>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = 6780486850535250008L;
    private Set<T> children = new LinkedHashSet<T>();
    private Map<String, Set<T>> invertedList = new HashMap<String, Set<T>>();

    public boolean addDocument(T d) {
        if (d == null) {
            throw new NullPointerException();
        }
        Set<String> v = d.getVocabulary();
        for (String s : v) {
            Set<T> inverted = this.invertedList.get(s);
            if (inverted == null) {
                inverted = new LinkedHashSet<T>();
                this.invertedList.put(s, inverted);
            }
            inverted.add(d);
        }
        if (d instanceof StateChangeObservable) {
            ((StateChangeObservable)d).addListener(this);
        }
        return this.addChildModel(d);
    }

    public void addDocumentAll(Collection<T> c) {
        for (DocumentModel d : c) {
            this.addDocument(d);
        }
    }

    public T getDocument(String id) {
        for (DocumentModel d : this.getChildrenModels()) {
            if (!d.getDocumentId().equals(id)) continue;
            return (T)d;
        }
        return null;
    }

    public boolean containsDocument(T d) {
        return this.getChildrenModels().contains(d);
    }

    public boolean containsDocument(String docid) {
        boolean contains = false;
        for (DocumentModel child : this.getChildrenModels()) {
            if (!child.getDocumentId().equals(docid)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public int documentFrequency(String term) {
        Set<T> set = this.invertedList.get(term);
        return set == null ? 0 : set.size();
    }

    public Set<T> getInvertedList(String term) {
        return new LinkedHashSet(this.invertedList.get(term));
    }

    public static <T extends DocumentModel> DocCollection<T> unmodifiableInstance(DocCollection<T> o) {
        return new UnmodifiableDocCollection<T>(o);
    }

    @Override
    protected Set<T> getChildrenModels() {
        return this.children;
    }

    @Override
    public Iterator<T> iterator() {
        return this.getChildrenModels().iterator();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.listeners);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = DocCollection.castCollection(in.readObject());
    }

    private static class UnmodifiableDocCollection<T extends DocumentModel>
    extends DocCollection<T> {
        private static final long serialVersionUID = -8214614790084393372L;

        public UnmodifiableDocCollection(DocCollection<T> o) {
            ((DocCollection)this).children = new LinkedHashSet(((DocCollection)o).children);
            ((DocCollection)this).invertedList = new HashMap(((DocCollection)o).invertedList);
        }

        @Override
        public boolean addDocument(T d) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addDocumentAll(Collection<T> c) {
            throw new UnsupportedOperationException();
        }
    }
}

