/*
 * Decompiled with CFR 0.152.
 */
package net.trialpc.sticktools.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.trialpc.sticktools.Smooth;
import net.trialpc.sticktools.model.AbstractLangModel;
import net.trialpc.sticktools.model.LangModel;

public class MultiSmoothedModel
extends AbstractLangModel
implements Serializable {
    private static final long serialVersionUID = -8861022370238332676L;
    private final LangModel base;
    private final List<BackgroundModel> bg = new ArrayList<BackgroundModel>();
    private transient List<BackgroundModel> reversed = null;

    public MultiSmoothedModel(LangModel base) {
        if (base == null) {
            throw new NullPointerException();
        }
        this.base = base;
    }

    public MultiSmoothedModel addBackgroundModel(LangModel bg, Smooth s, float param) {
        this.bg.add(new BackgroundModel(bg, s, param));
        this.reversed = null;
        return this;
    }

    @Override
    public Set<String> getVocabulary() {
        HashSet<String> v = new HashSet<String>(this.base.getVocabulary());
        for (BackgroundModel model : this.bg) {
            v.addAll(model.getVocabulary());
        }
        return v;
    }

    @Override
    public int numOfTerms() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int termCount(String term) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String toStringForDebug(String query) {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        builder.append("[query]");
        builder.append(query);
        builder.append("\n");
        builder.append("[base tfreq]");
        builder.append(this.base.termFrequency(query));
        builder.append("\n");
        for (BackgroundModel model : this.bg) {
            builder.append("[bg");
            builder.append(index);
            builder.append(" tfreq]");
            builder.append(model.termFrequency(query));
            builder.append("\n");
            ++index;
        }
        return builder.toString();
    }

    @Override
    public float termFrequency(String term) {
        float freq = 0.0f;
        BackgroundModel before = null;
        for (BackgroundModel model : this.getReversedList()) {
            if (before == null) {
                before = model;
                freq = model.termFrequency(term);
                continue;
            }
            float x = before.getParameter(model.numOfTerms(), model.numOfVocabulary());
            freq = x * model.termFrequency(term) + (1.0f - x) * freq;
            before = model;
        }
        if (before != null) {
            float x = before.getParameter(this.base.numOfTerms(), this.base.numOfVocabulary());
            freq = x * this.base.termFrequency(term) + (1.0f - x) * freq;
        } else {
            freq = this.base.termFrequency(term);
        }
        return freq;
    }

    private List<BackgroundModel> getReversedList() {
        if (this.reversed == null) {
            this.reversed = new ArrayList<BackgroundModel>(this.bg);
            Collections.reverse(this.reversed);
        }
        return this.reversed;
    }

    private static class BackgroundModel
    extends AbstractLangModel
    implements Serializable {
        private static final long serialVersionUID = -8808320789885258683L;
        private final LangModel model;
        private final Smooth method;
        private final float param;

        public BackgroundModel(LangModel model, Smooth s, float p) {
            this.model = model;
            this.method = s;
            this.param = p;
        }

        @Override
        public Set<String> getVocabulary() {
            return this.model.getVocabulary();
        }

        @Override
        public float termFrequency(String term) {
            return this.model.termFrequency(term);
        }

        public float getParameter(long num, long kind) {
            return this.method.getParameter(this.param, num, kind);
        }

        @Override
        public int numOfTerms() {
            return this.model.numOfTerms();
        }

        @Override
        public int termCount(String term) {
            throw new UnsupportedOperationException();
        }
    }
}

