/*
 * Decompiled with CFR 0.152.
 */
package net.trialpc.sticktools.model;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.trialpc.sticktools.model.AbstractModelBuilder;
import net.trialpc.sticktools.model.BaseSentence;
import net.trialpc.sticktools.model.DocCollection;
import net.trialpc.sticktools.model.SentenceModel;
import net.trialpc.sticktools.model.SentenceWrappedDocument;
import net.trialpc.sticktools.model.WrapDocument;

public class TriLayerModelBuilder
extends AbstractModelBuilder<DocCollection<WrapDocument<SentenceModel>>> {
    private Map<String, DocumentBuilder> documents = new LinkedHashMap<String, DocumentBuilder>();

    public boolean add(String docid, String sentid, String sentence) {
        DocumentBuilder builder = this.documents.get(docid);
        if (builder == null) {
            builder = new DocumentBuilder(docid);
            this.documents.put(docid, builder);
        }
        return builder.add(sentid, sentence);
    }

    public boolean add(String docid, SentenceModel sentence) {
        DocumentBuilder builder = this.documents.get(docid);
        if (builder == null) {
            builder = new DocumentBuilder(docid);
            this.documents.put(docid, builder);
        }
        return builder.add(sentence);
    }

    @Override
    public DocCollection<WrapDocument<SentenceModel>> build() {
        DocCollection<WrapDocument<SentenceModel>> dc = new DocCollection<WrapDocument<SentenceModel>>();
        for (DocumentBuilder builder : this.documents.values()) {
            dc.addDocument(builder.build());
        }
        return DocCollection.unmodifiableInstance(dc);
    }

    private class DocumentBuilder {
        private SentenceWrappedDocument<SentenceModel> d;

        public DocumentBuilder(String docid) {
            this.d = new SentenceWrappedDocument(docid);
        }

        public boolean add(String sid, String document) {
            List<String> terms = TriLayerModelBuilder.this.getTexts(document);
            BaseSentence s = new BaseSentence(sid);
            s.addTerms(terms);
            return this.d.addSentence(BaseSentence.unmodifiableSentence(s));
        }

        public boolean add(SentenceModel sentence) {
            return this.d.addSentence(sentence);
        }

        public WrapDocument<SentenceModel> build() {
            return this.d;
        }
    }
}

