/*
 * Decompiled with CFR 0.152.
 */
package net.trialpc.sticktools.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.trialpc.sticktools.model.AbstractLangModel;
import net.trialpc.sticktools.model.LangModel;
import net.trialpc.sticktools.model.StateChangeListener;
import net.trialpc.sticktools.model.StateChangeObservable;
import net.trialpc.sticktools.model.StateEvent;

public abstract class WrapModel<T extends LangModel>
extends AbstractLangModel
implements StateChangeListener,
StateChangeObservable {
    protected Collection<StateChangeListener> listeners;
    private boolean changedChildren = true;
    private boolean modifiable = true;
    private int numOfTerms = -1;
    private transient Map<String, Integer> terms;
    private transient Set<String> vocabulary;

    public WrapModel() {
        this(true);
    }

    public WrapModel(boolean notify) {
        if (notify) {
            this.listeners = new ArrayList<StateChangeListener>();
        }
    }

    @Override
    public boolean isModifiable() {
        if (this.changedChildren) {
            this.modifiable = false;
            for (LangModel child : this.getChildrenModels()) {
                if (!child.isModifiable()) continue;
                this.modifiable = true;
                break;
            }
            this.changedChildren = false;
        }
        return this.modifiable;
    }

    @Override
    public int numOfTerms() {
        if (this.isModifiable() || this.numOfTerms < 0) {
            this.numOfTerms = 0;
            for (LangModel model : this.getChildrenModels()) {
                this.numOfTerms += model.numOfTerms();
            }
        }
        return this.numOfTerms;
    }

    @Override
    public int termCount(String term) {
        if (this.isModifiable()) {
            this.terms = null;
            int num = 0;
            for (LangModel model : this.getChildrenModels()) {
                num += model.termCount(term);
            }
            return num;
        }
        if (this.terms == null) {
            this.terms = new HashMap<String, Integer>();
        }
        if (!this.terms.containsKey(term)) {
            int count = 0;
            for (LangModel model : this.getChildrenModels()) {
                count += model.termCount(term);
            }
            this.terms.put(term, count);
            return count;
        }
        return this.terms.get(term);
    }

    @Override
    public Set<String> getVocabulary() {
        if (this.isModifiable()) {
            this.vocabulary = null;
            HashSet<String> v = new HashSet<String>();
            for (LangModel model : this.getChildrenModels()) {
                v.addAll(model.getVocabulary());
            }
            return v;
        }
        if (this.vocabulary == null) {
            this.vocabulary = new HashSet<String>();
            for (LangModel model : this.getChildrenModels()) {
                this.vocabulary.addAll(model.getVocabulary());
            }
            this.vocabulary = Collections.unmodifiableSet(this.vocabulary);
        }
        return this.vocabulary;
    }

    @Override
    public void stateChanged(StateEvent event) {
        if (this.listeners != null) {
            for (StateChangeListener model : this.listeners) {
                this.notifyChange(model, event);
            }
        }
    }

    @Override
    public void addListener(StateChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.listeners != null) {
            this.listeners.add(listener);
        }
    }

    public int hashCode() {
        int code = 0;
        for (LangModel child : this.getChildrenModels()) {
            code &= child.hashCode();
        }
        return code;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WrapModel)) {
            return false;
        }
        return this.getChildrenModels().equals(((WrapModel)o).getChildrenModels());
    }

    private void notifyChange(StateChangeListener model, StateEvent event) {
        model.stateChanged(event);
    }

    protected boolean addChildModel(T model) {
        if (model == null) {
            throw new NullPointerException();
        }
        boolean key = this.getChildrenModels().add(model);
        if (key) {
            this.clearChache();
        }
        return key;
    }

    protected void addChildModelAll(Collection<T> c) {
        for (LangModel t : c) {
            this.addChildModel(t);
        }
    }

    protected abstract Set<T> getChildrenModels();

    protected static Collection<StateChangeListener> castCollection(Object o) {
        return (Collection)o;
    }

    private void clearChache() {
        this.changedChildren = true;
        this.numOfTerms = -1;
        this.terms = null;
        this.vocabulary = null;
    }
}

