/*
 * Decompiled with CFR 0.152.
 */
package net.trialpc.sticktools.stemmer;

import java.util.HashMap;
import java.util.Map;
import net.trialpc.sticktools.stemmer.Stemmer;

public class CachedStemmer
implements Stemmer {
    private Stemmer stemmer;
    private transient Map<String, String> cache;

    public CachedStemmer(Stemmer s) {
        this.stemmer = s;
    }

    @Override
    public String interpret(String term) {
        String t;
        if (this.cache == null) {
            this.cache = new HashMap<String, String>();
        }
        if ((t = this.cache.get(term)) == null) {
            String stemmed = this.stemmer.interpret(term);
            this.cache.put(term, stemmed);
            return stemmed;
        }
        return t;
    }

    public void clear() {
        this.cache = null;
    }

    public int hashCode() {
        return this.stemmer.hashCode() * 397;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CachedStemmer)) {
            return false;
        }
        CachedStemmer c = (CachedStemmer)o;
        return this.stemmer.equals(c.stemmer);
    }
}

