--
-- Copyright (C) 2016  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


with Interfaces.C;


package GLext is

   pragma Pure;

   use Interfaces;


   -- GLchar
   --
   subtype GLchar is C.char;

   type GLchar_array is
     array (C.size_t range <>) of aliased glext.GLchar;

   -- GLintptr
   --
   subtype GLintptr is C.ptrdiff_t;

   type GLintptr_array is
     array (C.size_t range <>) of aliased glext.GLintptr;

   -- GLsizeiptr
   --
   subtype GLsizeiptr is C.ptrdiff_t;

   type GLsizeiptr_array is
     array (C.size_t range <>) of aliased glext.GLsizeiptr;


   -- GLint64
   --
   subtype GLint64 is Interfaces.Integer_64;

   type GLint64_array is
     array (C.size_t range <>) of aliased glext.GLint64;

   -- GLuint64
   --
   subtype GLuint64 is Interfaces.Unsigned_64;

   type GLuint64_array is
     array (C.size_t range <>) of aliased glext.GLuint64;

   GL_GLEXT_VERSION                                   : constant := 63;
   GL_BLEND_DST_RGB                                   : constant := 16#80c8#;
   GL_BLEND_SRC_RGB                                   : constant := 16#80c9#;
   GL_BLEND_DST_ALPHA                                 : constant := 16#80ca#;
   GL_BLEND_SRC_ALPHA                                 : constant := 16#80cb#;
   GL_POINT_FADE_THRESHOLD_SIZE                       : constant := 16#8128#;
   GL_DEPTH_COMPONENT16                               : constant := 16#81a5#;
   GL_DEPTH_COMPONENT24                               : constant := 16#81a6#;
   GL_DEPTH_COMPONENT32                               : constant := 16#81a7#;
   GL_MIRRORED_REPEAT                                 : constant := 16#8370#;
   GL_MAX_TEXTURE_LOD_BIAS                            : constant := 16#84fd#;
   GL_TEXTURE_LOD_BIAS                                : constant := 16#8501#;
   GL_INCR_WRAP                                       : constant := 16#8507#;
   GL_DECR_WRAP                                       : constant := 16#8508#;
   GL_TEXTURE_DEPTH_SIZE                              : constant := 16#884a#;
   GL_TEXTURE_COMPARE_MODE                            : constant := 16#884c#;
   GL_TEXTURE_COMPARE_FUNC                            : constant := 16#884d#;
   GL_POINT_SIZE_MIN                                  : constant := 16#8126#;
   GL_POINT_SIZE_MAX                                  : constant := 16#8127#;
   GL_POINT_DISTANCE_ATTENUATION                      : constant := 16#8129#;
   GL_GENERATE_MIPMAP                                 : constant := 16#8191#;
   GL_GENERATE_MIPMAP_HINT                            : constant := 16#8192#;
   GL_FOG_COORDINATE_SOURCE                           : constant := 16#8450#;
   GL_FOG_COORDINATE                                  : constant := 16#8451#;
   GL_FRAGMENT_DEPTH                                  : constant := 16#8452#;
   GL_CURRENT_FOG_COORDINATE                          : constant := 16#8453#;
   GL_FOG_COORDINATE_ARRAY_TYPE                       : constant := 16#8454#;
   GL_FOG_COORDINATE_ARRAY_STRIDE                     : constant := 16#8455#;
   GL_FOG_COORDINATE_ARRAY_POINTER                    : constant := 16#8456#;
   GL_FOG_COORDINATE_ARRAY                            : constant := 16#8457#;
   GL_COLOR_SUM                                       : constant := 16#8458#;
   GL_CURRENT_SECONDARY_COLOR                         : constant := 16#8459#;
   GL_SECONDARY_COLOR_ARRAY_SIZE                      : constant := 16#845a#;
   GL_SECONDARY_COLOR_ARRAY_TYPE                      : constant := 16#845b#;
   GL_SECONDARY_COLOR_ARRAY_STRIDE                    : constant := 16#845c#;
   GL_SECONDARY_COLOR_ARRAY_POINTER                   : constant := 16#845d#;
   GL_SECONDARY_COLOR_ARRAY                           : constant := 16#845e#;
   GL_TEXTURE_FILTER_CONTROL                          : constant := 16#8500#;
   GL_DEPTH_TEXTURE_MODE                              : constant := 16#884b#;
   GL_COMPARE_R_TO_TEXTURE                            : constant := 16#884e#;
   GL_BUFFER_SIZE                                     : constant := 16#8764#;
   GL_BUFFER_USAGE                                    : constant := 16#8765#;
   GL_QUERY_COUNTER_BITS                              : constant := 16#8864#;
   GL_CURRENT_QUERY                                   : constant := 16#8865#;
   GL_QUERY_RESULT                                    : constant := 16#8866#;
   GL_QUERY_RESULT_AVAILABLE                          : constant := 16#8867#;
   GL_ARRAY_BUFFER                                    : constant := 16#8892#;
   GL_ELEMENT_ARRAY_BUFFER                            : constant := 16#8893#;
   GL_ARRAY_BUFFER_BINDING                            : constant := 16#8894#;
   GL_ELEMENT_ARRAY_BUFFER_BINDING                    : constant := 16#8895#;
   GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING              : constant := 16#889f#;
   GL_READ_ONLY                                       : constant := 16#88b8#;
   GL_WRITE_ONLY                                      : constant := 16#88b9#;
   GL_READ_WRITE                                      : constant := 16#88ba#;
   GL_BUFFER_ACCESS                                   : constant := 16#88bb#;
   GL_BUFFER_MAPPED                                   : constant := 16#88bc#;
   GL_BUFFER_MAP_POINTER                              : constant := 16#88bd#;
   GL_STREAM_DRAW                                     : constant := 16#88e0#;
   GL_STREAM_READ                                     : constant := 16#88e1#;
   GL_STREAM_COPY                                     : constant := 16#88e2#;
   GL_STATIC_DRAW                                     : constant := 16#88e4#;
   GL_STATIC_READ                                     : constant := 16#88e5#;
   GL_STATIC_COPY                                     : constant := 16#88e6#;
   GL_DYNAMIC_DRAW                                    : constant := 16#88e8#;
   GL_DYNAMIC_READ                                    : constant := 16#88e9#;
   GL_DYNAMIC_COPY                                    : constant := 16#88ea#;
   GL_SAMPLES_PASSED                                  : constant := 16#8914#;
   GL_VERTEX_ARRAY_BUFFER_BINDING                     : constant := 16#8896#;
   GL_NORMAL_ARRAY_BUFFER_BINDING                     : constant := 16#8897#;
   GL_COLOR_ARRAY_BUFFER_BINDING                      : constant := 16#8898#;
   GL_INDEX_ARRAY_BUFFER_BINDING                      : constant := 16#8899#;
   GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING              : constant := 16#889a#;
   GL_EDGE_FLAG_ARRAY_BUFFER_BINDING                  : constant := 16#889b#;
   GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING            : constant := 16#889c#;
   GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING             : constant := 16#889d#;
   GL_WEIGHT_ARRAY_BUFFER_BINDING                     : constant := 16#889e#;
   GL_FOG_COORD_SRC                                   : constant := 16#8450#;
   GL_FOG_COORD                                       : constant := 16#8451#;
   GL_CURRENT_FOG_COORD                               : constant := 16#8453#;
   GL_FOG_COORD_ARRAY_TYPE                            : constant := 16#8454#;
   GL_FOG_COORD_ARRAY_STRIDE                          : constant := 16#8455#;
   GL_FOG_COORD_ARRAY_POINTER                         : constant := 16#8456#;
   GL_FOG_COORD_ARRAY                                 : constant := 16#8457#;
   GL_FOG_COORD_ARRAY_BUFFER_BINDING                  : constant := 16#889d#;
   GL_SRC0_RGB                                        : constant := 16#8580#;
   GL_SRC1_RGB                                        : constant := 16#8581#;
   GL_SRC2_RGB                                        : constant := 16#8582#;
   GL_SRC0_ALPHA                                      : constant := 16#8588#;
   GL_SRC1_ALPHA                                      : constant := 16#8589#;
   GL_SRC2_ALPHA                                      : constant := 16#858a#;
   GL_BLEND_EQUATION_RGB                              : constant := 16#8009#;
   GL_VERTEX_ATTRIB_ARRAY_ENABLED                     : constant := 16#8622#;
   GL_VERTEX_ATTRIB_ARRAY_SIZE                        : constant := 16#8623#;
   GL_VERTEX_ATTRIB_ARRAY_STRIDE                      : constant := 16#8624#;
   GL_VERTEX_ATTRIB_ARRAY_TYPE                        : constant := 16#8625#;
   GL_CURRENT_VERTEX_ATTRIB                           : constant := 16#8626#;
   GL_VERTEX_PROGRAM_POINT_SIZE                       : constant := 16#8642#;
   GL_VERTEX_ATTRIB_ARRAY_POINTER                     : constant := 16#8645#;
   GL_STENCIL_BACK_FUNC                               : constant := 16#8800#;
   GL_STENCIL_BACK_FAIL                               : constant := 16#8801#;
   GL_STENCIL_BACK_PASS_DEPTH_FAIL                    : constant := 16#8802#;
   GL_STENCIL_BACK_PASS_DEPTH_PASS                    : constant := 16#8803#;
   GL_MAX_DRAW_BUFFERS                                : constant := 16#8824#;
   GL_DRAW_BUFFER0                                    : constant := 16#8825#;
   GL_DRAW_BUFFER1                                    : constant := 16#8826#;
   GL_DRAW_BUFFER2                                    : constant := 16#8827#;
   GL_DRAW_BUFFER3                                    : constant := 16#8828#;
   GL_DRAW_BUFFER4                                    : constant := 16#8829#;
   GL_DRAW_BUFFER5                                    : constant := 16#882a#;
   GL_DRAW_BUFFER6                                    : constant := 16#882b#;
   GL_DRAW_BUFFER7                                    : constant := 16#882c#;
   GL_DRAW_BUFFER8                                    : constant := 16#882d#;
   GL_DRAW_BUFFER9                                    : constant := 16#882e#;
   GL_DRAW_BUFFER10                                   : constant := 16#882f#;
   GL_DRAW_BUFFER11                                   : constant := 16#8830#;
   GL_DRAW_BUFFER12                                   : constant := 16#8831#;
   GL_DRAW_BUFFER13                                   : constant := 16#8832#;
   GL_DRAW_BUFFER14                                   : constant := 16#8833#;
   GL_DRAW_BUFFER15                                   : constant := 16#8834#;
   GL_BLEND_EQUATION_ALPHA                            : constant := 16#883d#;
   GL_MAX_VERTEX_ATTRIBS                              : constant := 16#8869#;
   GL_VERTEX_ATTRIB_ARRAY_NORMALIZED                  : constant := 16#886a#;
   GL_MAX_TEXTURE_IMAGE_UNITS                         : constant := 16#8872#;
   GL_FRAGMENT_SHADER                                 : constant := 16#8b30#;
   GL_VERTEX_SHADER                                   : constant := 16#8b31#;
   GL_MAX_FRAGMENT_UNIFORM_COMPONENTS                 : constant := 16#8b49#;
   GL_MAX_VERTEX_UNIFORM_COMPONENTS                   : constant := 16#8b4a#;
   GL_MAX_VARYING_FLOATS                              : constant := 16#8b4b#;
   GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS                  : constant := 16#8b4c#;
   GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS                : constant := 16#8b4d#;
   GL_SHADER_TYPE                                     : constant := 16#8b4f#;
   GL_FLOAT_VEC2                                      : constant := 16#8b50#;
   GL_FLOAT_VEC3                                      : constant := 16#8b51#;
   GL_FLOAT_VEC4                                      : constant := 16#8b52#;
   GL_INT_VEC2                                        : constant := 16#8b53#;
   GL_INT_VEC3                                        : constant := 16#8b54#;
   GL_INT_VEC4                                        : constant := 16#8b55#;
   GL_BOOL                                            : constant := 16#8b56#;
   GL_BOOL_VEC2                                       : constant := 16#8b57#;
   GL_BOOL_VEC3                                       : constant := 16#8b58#;
   GL_BOOL_VEC4                                       : constant := 16#8b59#;
   GL_FLOAT_MAT2                                      : constant := 16#8b5a#;
   GL_FLOAT_MAT3                                      : constant := 16#8b5b#;
   GL_FLOAT_MAT4                                      : constant := 16#8b5c#;
   GL_SAMPLER_1D                                      : constant := 16#8b5d#;
   GL_SAMPLER_2D                                      : constant := 16#8b5e#;
   GL_SAMPLER_3D                                      : constant := 16#8b5f#;
   GL_SAMPLER_CUBE                                    : constant := 16#8b60#;
   GL_SAMPLER_1D_SHADOW                               : constant := 16#8b61#;
   GL_SAMPLER_2D_SHADOW                               : constant := 16#8b62#;
   GL_DELETE_STATUS                                   : constant := 16#8b80#;
   GL_COMPILE_STATUS                                  : constant := 16#8b81#;
   GL_LINK_STATUS                                     : constant := 16#8b82#;
   GL_VALIDATE_STATUS                                 : constant := 16#8b83#;
   GL_INFO_LOG_LENGTH                                 : constant := 16#8b84#;
   GL_ATTACHED_SHADERS                                : constant := 16#8b85#;
   GL_ACTIVE_UNIFORMS                                 : constant := 16#8b86#;
   GL_ACTIVE_UNIFORM_MAX_LENGTH                       : constant := 16#8b87#;
   GL_SHADER_SOURCE_LENGTH                            : constant := 16#8b88#;
   GL_ACTIVE_ATTRIBUTES                               : constant := 16#8b89#;
   GL_ACTIVE_ATTRIBUTE_MAX_LENGTH                     : constant := 16#8b8a#;
   GL_FRAGMENT_SHADER_DERIVATIVE_HINT                 : constant := 16#8b8b#;
   GL_SHADING_LANGUAGE_VERSION                        : constant := 16#8b8c#;
   GL_CURRENT_PROGRAM                                 : constant := 16#8b8d#;
   GL_POINT_SPRITE_COORD_ORIGIN                       : constant := 16#8ca0#;
   GL_LOWER_LEFT                                      : constant := 16#8ca1#;
   GL_UPPER_LEFT                                      : constant := 16#8ca2#;
   GL_STENCIL_BACK_REF                                : constant := 16#8ca3#;
   GL_STENCIL_BACK_VALUE_MASK                         : constant := 16#8ca4#;
   GL_STENCIL_BACK_WRITEMASK                          : constant := 16#8ca5#;
   GL_VERTEX_PROGRAM_TWO_SIDE                         : constant := 16#8643#;
   GL_POINT_SPRITE                                    : constant := 16#8861#;
   GL_COORD_REPLACE                                   : constant := 16#8862#;
   GL_MAX_TEXTURE_COORDS                              : constant := 16#8871#;
   GL_PIXEL_PACK_BUFFER                               : constant := 16#88eb#;
   GL_PIXEL_UNPACK_BUFFER                             : constant := 16#88ec#;
   GL_PIXEL_PACK_BUFFER_BINDING                       : constant := 16#88ed#;
   GL_PIXEL_UNPACK_BUFFER_BINDING                     : constant := 16#88ef#;
   GL_FLOAT_MAT2x3                                    : constant := 16#8b65#;
   GL_FLOAT_MAT2x4                                    : constant := 16#8b66#;
   GL_FLOAT_MAT3x2                                    : constant := 16#8b67#;
   GL_FLOAT_MAT3x4                                    : constant := 16#8b68#;
   GL_FLOAT_MAT4x2                                    : constant := 16#8b69#;
   GL_FLOAT_MAT4x3                                    : constant := 16#8b6a#;
   GL_SRGB                                            : constant := 16#8c40#;
   GL_SRGB8                                           : constant := 16#8c41#;
   GL_SRGB_ALPHA                                      : constant := 16#8c42#;
   GL_SRGB8_ALPHA8                                    : constant := 16#8c43#;
   GL_COMPRESSED_SRGB                                 : constant := 16#8c48#;
   GL_COMPRESSED_SRGB_ALPHA                           : constant := 16#8c49#;
   GL_CURRENT_RASTER_SECONDARY_COLOR                  : constant := 16#845f#;
   GL_SLUMINANCE_ALPHA                                : constant := 16#8c44#;
   GL_SLUMINANCE8_ALPHA8                              : constant := 16#8c45#;
   GL_SLUMINANCE                                      : constant := 16#8c46#;
   GL_SLUMINANCE8                                     : constant := 16#8c47#;
   GL_COMPRESSED_SLUMINANCE                           : constant := 16#8c4a#;
   GL_COMPRESSED_SLUMINANCE_ALPHA                     : constant := 16#8c4b#;
   GL_COMPARE_REF_TO_TEXTURE                          : constant := 16#884e#;
   GL_CLIP_DISTANCE0                                  : constant := 16#3000#;
   GL_CLIP_DISTANCE1                                  : constant := 16#3001#;
   GL_CLIP_DISTANCE2                                  : constant := 16#3002#;
   GL_CLIP_DISTANCE3                                  : constant := 16#3003#;
   GL_CLIP_DISTANCE4                                  : constant := 16#3004#;
   GL_CLIP_DISTANCE5                                  : constant := 16#3005#;
   GL_CLIP_DISTANCE6                                  : constant := 16#3006#;
   GL_CLIP_DISTANCE7                                  : constant := 16#3007#;
   GL_MAX_CLIP_DISTANCES                              : constant := 16#d32#;
   GL_MAJOR_VERSION                                   : constant := 16#821b#;
   GL_MINOR_VERSION                                   : constant := 16#821c#;
   GL_NUM_EXTENSIONS                                  : constant := 16#821d#;
   GL_CONTEXT_FLAGS                                   : constant := 16#821e#;
   GL_DEPTH_BUFFER                                    : constant := 16#8223#;
   GL_STENCIL_BUFFER                                  : constant := 16#8224#;
   GL_COMPRESSED_RED                                  : constant := 16#8225#;
   GL_COMPRESSED_RG                                   : constant := 16#8226#;
   GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT             : constant := 16#1#;
   GL_RGBA32F                                         : constant := 16#8814#;
   GL_RGB32F                                          : constant := 16#8815#;
   GL_RGBA16F                                         : constant := 16#881a#;
   GL_RGB16F                                          : constant := 16#881b#;
   GL_VERTEX_ATTRIB_ARRAY_INTEGER                     : constant := 16#88fd#;
   GL_MAX_ARRAY_TEXTURE_LAYERS                        : constant := 16#88ff#;
   GL_MIN_PROGRAM_TEXEL_OFFSET                        : constant := 16#8904#;
   GL_MAX_PROGRAM_TEXEL_OFFSET                        : constant := 16#8905#;
   GL_CLAMP_READ_COLOR                                : constant := 16#891c#;
   GL_FIXED_ONLY                                      : constant := 16#891d#;
   GL_MAX_VARYING_COMPONENTS                          : constant := 16#8b4b#;
   GL_TEXTURE_1D_ARRAY                                : constant := 16#8c18#;
   GL_PROXY_TEXTURE_1D_ARRAY                          : constant := 16#8c19#;
   GL_TEXTURE_2D_ARRAY                                : constant := 16#8c1a#;
   GL_PROXY_TEXTURE_2D_ARRAY                          : constant := 16#8c1b#;
   GL_TEXTURE_BINDING_1D_ARRAY                        : constant := 16#8c1c#;
   GL_TEXTURE_BINDING_2D_ARRAY                        : constant := 16#8c1d#;
   GL_R11F_G11F_B10F                                  : constant := 16#8c3a#;
   GL_UNSIGNED_INT_10F_11F_11F_REV                    : constant := 16#8c3b#;
   GL_RGB9_E5                                         : constant := 16#8c3d#;
   GL_UNSIGNED_INT_5_9_9_9_REV                        : constant := 16#8c3e#;
   GL_TEXTURE_SHARED_SIZE                             : constant := 16#8c3f#;
   GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH           : constant := 16#8c76#;
   GL_TRANSFORM_FEEDBACK_BUFFER_MODE                  : constant := 16#8c7f#;
   GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS      : constant := 16#8c80#;
   GL_TRANSFORM_FEEDBACK_VARYINGS                     : constant := 16#8c83#;
   GL_TRANSFORM_FEEDBACK_BUFFER_START                 : constant := 16#8c84#;
   GL_TRANSFORM_FEEDBACK_BUFFER_SIZE                  : constant := 16#8c85#;
   GL_PRIMITIVES_GENERATED                            : constant := 16#8c87#;
   GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN           : constant := 16#8c88#;
   GL_RASTERIZER_DISCARD                              : constant := 16#8c89#;
   GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS   : constant := 16#8c8a#;
   GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS         : constant := 16#8c8b#;
   GL_INTERLEAVED_ATTRIBS                             : constant := 16#8c8c#;
   GL_SEPARATE_ATTRIBS                                : constant := 16#8c8d#;
   GL_TRANSFORM_FEEDBACK_BUFFER                       : constant := 16#8c8e#;
   GL_TRANSFORM_FEEDBACK_BUFFER_BINDING               : constant := 16#8c8f#;
   GL_RGBA32UI                                        : constant := 16#8d70#;
   GL_RGB32UI                                         : constant := 16#8d71#;
   GL_RGBA16UI                                        : constant := 16#8d76#;
   GL_RGB16UI                                         : constant := 16#8d77#;
   GL_RGBA8UI                                         : constant := 16#8d7c#;
   GL_RGB8UI                                          : constant := 16#8d7d#;
   GL_RGBA32I                                         : constant := 16#8d82#;
   GL_RGB32I                                          : constant := 16#8d83#;
   GL_RGBA16I                                         : constant := 16#8d88#;
   GL_RGB16I                                          : constant := 16#8d89#;
   GL_RGBA8I                                          : constant := 16#8d8e#;
   GL_RGB8I                                           : constant := 16#8d8f#;
   GL_RED_INTEGER                                     : constant := 16#8d94#;
   GL_GREEN_INTEGER                                   : constant := 16#8d95#;
   GL_BLUE_INTEGER                                    : constant := 16#8d96#;
   GL_RGB_INTEGER                                     : constant := 16#8d98#;
   GL_RGBA_INTEGER                                    : constant := 16#8d99#;
   GL_BGR_INTEGER                                     : constant := 16#8d9a#;
   GL_BGRA_INTEGER                                    : constant := 16#8d9b#;
   GL_SAMPLER_1D_ARRAY                                : constant := 16#8dc0#;
   GL_SAMPLER_2D_ARRAY                                : constant := 16#8dc1#;
   GL_SAMPLER_1D_ARRAY_SHADOW                         : constant := 16#8dc3#;
   GL_SAMPLER_2D_ARRAY_SHADOW                         : constant := 16#8dc4#;
   GL_SAMPLER_CUBE_SHADOW                             : constant := 16#8dc5#;
   GL_UNSIGNED_INT_VEC2                               : constant := 16#8dc6#;
   GL_UNSIGNED_INT_VEC3                               : constant := 16#8dc7#;
   GL_UNSIGNED_INT_VEC4                               : constant := 16#8dc8#;
   GL_INT_SAMPLER_1D                                  : constant := 16#8dc9#;
   GL_INT_SAMPLER_2D                                  : constant := 16#8dca#;
   GL_INT_SAMPLER_3D                                  : constant := 16#8dcb#;
   GL_INT_SAMPLER_CUBE                                : constant := 16#8dcc#;
   GL_INT_SAMPLER_1D_ARRAY                            : constant := 16#8dce#;
   GL_INT_SAMPLER_2D_ARRAY                            : constant := 16#8dcf#;
   GL_UNSIGNED_INT_SAMPLER_1D                         : constant := 16#8dd1#;
   GL_UNSIGNED_INT_SAMPLER_2D                         : constant := 16#8dd2#;
   GL_UNSIGNED_INT_SAMPLER_3D                         : constant := 16#8dd3#;
   GL_UNSIGNED_INT_SAMPLER_CUBE                       : constant := 16#8dd4#;
   GL_UNSIGNED_INT_SAMPLER_1D_ARRAY                   : constant := 16#8dd6#;
   GL_UNSIGNED_INT_SAMPLER_2D_ARRAY                   : constant := 16#8dd7#;
   GL_QUERY_WAIT                                      : constant := 16#8e13#;
   GL_QUERY_NO_WAIT                                   : constant := 16#8e14#;
   GL_QUERY_BY_REGION_WAIT                            : constant := 16#8e15#;
   GL_QUERY_BY_REGION_NO_WAIT                         : constant := 16#8e16#;
   GL_BUFFER_ACCESS_FLAGS                             : constant := 16#911f#;
   GL_BUFFER_MAP_LENGTH                               : constant := 16#9120#;
   GL_BUFFER_MAP_OFFSET                               : constant := 16#9121#;
   GL_CLAMP_VERTEX_COLOR                              : constant := 16#891a#;
   GL_CLAMP_FRAGMENT_COLOR                            : constant := 16#891b#;
   GL_ALPHA_INTEGER                                   : constant := 16#8d97#;
   GL_SAMPLER_2D_RECT                                 : constant := 16#8b63#;
   GL_SAMPLER_2D_RECT_SHADOW                          : constant := 16#8b64#;
   GL_SAMPLER_BUFFER                                  : constant := 16#8dc2#;
   GL_INT_SAMPLER_2D_RECT                             : constant := 16#8dcd#;
   GL_INT_SAMPLER_BUFFER                              : constant := 16#8dd0#;
   GL_UNSIGNED_INT_SAMPLER_2D_RECT                    : constant := 16#8dd5#;
   GL_UNSIGNED_INT_SAMPLER_BUFFER                     : constant := 16#8dd8#;
   GL_TEXTURE_BUFFER                                  : constant := 16#8c2a#;
   GL_MAX_TEXTURE_BUFFER_SIZE                         : constant := 16#8c2b#;
   GL_TEXTURE_BINDING_BUFFER                          : constant := 16#8c2c#;
   GL_TEXTURE_BUFFER_DATA_STORE_BINDING               : constant := 16#8c2d#;
   GL_TEXTURE_BUFFER_FORMAT                           : constant := 16#8c2e#;
   GL_TEXTURE_RECTANGLE                               : constant := 16#84f5#;
   GL_TEXTURE_BINDING_RECTANGLE                       : constant := 16#84f6#;
   GL_PROXY_TEXTURE_RECTANGLE                         : constant := 16#84f7#;
   GL_MAX_RECTANGLE_TEXTURE_SIZE                      : constant := 16#84f8#;
   GL_RED_SNORM                                       : constant := 16#8f90#;
   GL_RG_SNORM                                        : constant := 16#8f91#;
   GL_RGB_SNORM                                       : constant := 16#8f92#;
   GL_RGBA_SNORM                                      : constant := 16#8f93#;
   GL_R8_SNORM                                        : constant := 16#8f94#;
   GL_RG8_SNORM                                       : constant := 16#8f95#;
   GL_RGB8_SNORM                                      : constant := 16#8f96#;
   GL_RGBA8_SNORM                                     : constant := 16#8f97#;
   GL_R16_SNORM                                       : constant := 16#8f98#;
   GL_RG16_SNORM                                      : constant := 16#8f99#;
   GL_RGB16_SNORM                                     : constant := 16#8f9a#;
   GL_RGBA16_SNORM                                    : constant := 16#8f9b#;
   GL_SIGNED_NORMALIZED                               : constant := 16#8f9c#;
   GL_PRIMITIVE_RESTART                               : constant := 16#8f9d#;
   GL_PRIMITIVE_RESTART_INDEX                         : constant := 16#8f9e#;
   GL_CONTEXT_CORE_PROFILE_BIT                        : constant := 16#1#;
   GL_CONTEXT_COMPATIBILITY_PROFILE_BIT               : constant := 16#2#;
   GL_LINES_ADJACENCY                                 : constant := 16#a#;
   GL_LINE_STRIP_ADJACENCY                            : constant := 16#b#;
   GL_TRIANGLES_ADJACENCY                             : constant := 16#c#;
   GL_TRIANGLE_STRIP_ADJACENCY                        : constant := 16#d#;
   GL_PROGRAM_POINT_SIZE                              : constant := 16#8642#;
   GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS                : constant := 16#8c29#;
   GL_FRAMEBUFFER_ATTACHMENT_LAYERED                  : constant := 16#8da7#;
   GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS            : constant := 16#8da8#;
   GL_GEOMETRY_SHADER                                 : constant := 16#8dd9#;
   GL_GEOMETRY_VERTICES_OUT                           : constant := 16#8916#;
   GL_GEOMETRY_INPUT_TYPE                             : constant := 16#8917#;
   GL_GEOMETRY_OUTPUT_TYPE                            : constant := 16#8918#;
   GL_MAX_GEOMETRY_UNIFORM_COMPONENTS                 : constant := 16#8ddf#;
   GL_MAX_GEOMETRY_OUTPUT_VERTICES                    : constant := 16#8de0#;
   GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS            : constant := 16#8de1#;
   GL_MAX_VERTEX_OUTPUT_COMPONENTS                    : constant := 16#9122#;
   GL_MAX_GEOMETRY_INPUT_COMPONENTS                   : constant := 16#9123#;
   GL_MAX_GEOMETRY_OUTPUT_COMPONENTS                  : constant := 16#9124#;
   GL_MAX_FRAGMENT_INPUT_COMPONENTS                   : constant := 16#9125#;
   GL_CONTEXT_PROFILE_MASK                            : constant := 16#9126#;
   GL_DEPTH_COMPONENT32F                              : constant := 16#8cac#;
   GL_DEPTH32F_STENCIL8                               : constant := 16#8cad#;
   GL_FLOAT_32_UNSIGNED_INT_24_8_REV                  : constant := 16#8dad#;
   GL_INVALID_FRAMEBUFFER_OPERATION                   : constant := 16#506#;
   GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING           : constant := 16#8210#;
   GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE           : constant := 16#8211#;
   GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE                 : constant := 16#8212#;
   GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE               : constant := 16#8213#;
   GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE                : constant := 16#8214#;
   GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE               : constant := 16#8215#;
   GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE               : constant := 16#8216#;
   GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE             : constant := 16#8217#;
   GL_FRAMEBUFFER_DEFAULT                             : constant := 16#8218#;
   GL_FRAMEBUFFER_UNDEFINED                           : constant := 16#8219#;
   GL_DEPTH_STENCIL_ATTACHMENT                        : constant := 16#821a#;
   GL_MAX_RENDERBUFFER_SIZE                           : constant := 16#84e8#;
   GL_DEPTH_STENCIL                                   : constant := 16#84f9#;
   GL_UNSIGNED_INT_24_8                               : constant := 16#84fa#;
   GL_DEPTH24_STENCIL8                                : constant := 16#88f0#;
   GL_TEXTURE_STENCIL_SIZE                            : constant := 16#88f1#;
   GL_TEXTURE_RED_TYPE                                : constant := 16#8c10#;
   GL_TEXTURE_GREEN_TYPE                              : constant := 16#8c11#;
   GL_TEXTURE_BLUE_TYPE                               : constant := 16#8c12#;
   GL_TEXTURE_ALPHA_TYPE                              : constant := 16#8c13#;
   GL_TEXTURE_DEPTH_TYPE                              : constant := 16#8c16#;
   GL_UNSIGNED_NORMALIZED                             : constant := 16#8c17#;
   GL_FRAMEBUFFER_BINDING                             : constant := 16#8ca6#;
   GL_DRAW_FRAMEBUFFER_BINDING                        : constant := 16#8ca6#;
   GL_RENDERBUFFER_BINDING                            : constant := 16#8ca7#;
   GL_READ_FRAMEBUFFER                                : constant := 16#8ca8#;
   GL_DRAW_FRAMEBUFFER                                : constant := 16#8ca9#;
   GL_READ_FRAMEBUFFER_BINDING                        : constant := 16#8caa#;
   GL_RENDERBUFFER_SAMPLES                            : constant := 16#8cab#;
   GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE              : constant := 16#8cd0#;
   GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME              : constant := 16#8cd1#;
   GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL            : constant := 16#8cd2#;
   GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE    : constant := 16#8cd3#;
   GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER            : constant := 16#8cd4#;
   GL_FRAMEBUFFER_COMPLETE                            : constant := 16#8cd5#;
   GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT               : constant := 16#8cd6#;
   GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT       : constant := 16#8cd7#;
   GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER              : constant := 16#8cdb#;
   GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER              : constant := 16#8cdc#;
   GL_FRAMEBUFFER_UNSUPPORTED                         : constant := 16#8cdd#;
   GL_MAX_COLOR_ATTACHMENTS                           : constant := 16#8cdf#;
   GL_COLOR_ATTACHMENT0                               : constant := 16#8ce0#;
   GL_COLOR_ATTACHMENT1                               : constant := 16#8ce1#;
   GL_COLOR_ATTACHMENT2                               : constant := 16#8ce2#;
   GL_COLOR_ATTACHMENT3                               : constant := 16#8ce3#;
   GL_COLOR_ATTACHMENT4                               : constant := 16#8ce4#;
   GL_COLOR_ATTACHMENT5                               : constant := 16#8ce5#;
   GL_COLOR_ATTACHMENT6                               : constant := 16#8ce6#;
   GL_COLOR_ATTACHMENT7                               : constant := 16#8ce7#;
   GL_COLOR_ATTACHMENT8                               : constant := 16#8ce8#;
   GL_COLOR_ATTACHMENT9                               : constant := 16#8ce9#;
   GL_COLOR_ATTACHMENT10                              : constant := 16#8cea#;
   GL_COLOR_ATTACHMENT11                              : constant := 16#8ceb#;
   GL_COLOR_ATTACHMENT12                              : constant := 16#8cec#;
   GL_COLOR_ATTACHMENT13                              : constant := 16#8ced#;
   GL_COLOR_ATTACHMENT14                              : constant := 16#8cee#;
   GL_COLOR_ATTACHMENT15                              : constant := 16#8cef#;
   GL_DEPTH_ATTACHMENT                                : constant := 16#8d00#;
   GL_STENCIL_ATTACHMENT                              : constant := 16#8d20#;
   GL_FRAMEBUFFER                                     : constant := 16#8d40#;
   GL_RENDERBUFFER                                    : constant := 16#8d41#;
   GL_RENDERBUFFER_WIDTH                              : constant := 16#8d42#;
   GL_RENDERBUFFER_HEIGHT                             : constant := 16#8d43#;
   GL_RENDERBUFFER_INTERNAL_FORMAT                    : constant := 16#8d44#;
   GL_STENCIL_INDEX1                                  : constant := 16#8d46#;
   GL_STENCIL_INDEX4                                  : constant := 16#8d47#;
   GL_STENCIL_INDEX8                                  : constant := 16#8d48#;
   GL_STENCIL_INDEX16                                 : constant := 16#8d49#;
   GL_RENDERBUFFER_RED_SIZE                           : constant := 16#8d50#;
   GL_RENDERBUFFER_GREEN_SIZE                         : constant := 16#8d51#;
   GL_RENDERBUFFER_BLUE_SIZE                          : constant := 16#8d52#;
   GL_RENDERBUFFER_ALPHA_SIZE                         : constant := 16#8d53#;
   GL_RENDERBUFFER_DEPTH_SIZE                         : constant := 16#8d54#;
   GL_RENDERBUFFER_STENCIL_SIZE                       : constant := 16#8d55#;
   GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE              : constant := 16#8d56#;
   GL_MAX_SAMPLES                                     : constant := 16#8d57#;
   GL_INDEX                                           : constant := 16#8222#;
   GL_TEXTURE_LUMINANCE_TYPE                          : constant := 16#8c14#;
   GL_TEXTURE_INTENSITY_TYPE                          : constant := 16#8c15#;
   GL_FRAMEBUFFER_SRGB                                : constant := 16#8db9#;
   GL_HALF_FLOAT                                      : constant := 16#140b#;
   GL_MAP_READ_BIT                                    : constant := 16#1#;
   GL_MAP_WRITE_BIT                                   : constant := 16#2#;
   GL_MAP_INVALIDATE_RANGE_BIT                        : constant := 16#4#;
   GL_MAP_INVALIDATE_BUFFER_BIT                       : constant := 16#8#;
   GL_MAP_FLUSH_EXPLICIT_BIT                          : constant := 16#10#;
   GL_MAP_UNSYNCHRONIZED_BIT                          : constant := 16#20#;
   GL_COMPRESSED_RED_RGTC1                            : constant := 16#8dbb#;
   GL_COMPRESSED_SIGNED_RED_RGTC1                     : constant := 16#8dbc#;
   GL_COMPRESSED_RG_RGTC2                             : constant := 16#8dbd#;
   GL_COMPRESSED_SIGNED_RG_RGTC2                      : constant := 16#8dbe#;
   GL_RG                                              : constant := 16#8227#;
   GL_RG_INTEGER                                      : constant := 16#8228#;
   GL_R8                                              : constant := 16#8229#;
   GL_R16                                             : constant := 16#822a#;
   GL_RG8                                             : constant := 16#822b#;
   GL_RG16                                            : constant := 16#822c#;
   GL_R16F                                            : constant := 16#822d#;
   GL_R32F                                            : constant := 16#822e#;
   GL_RG16F                                           : constant := 16#822f#;
   GL_RG32F                                           : constant := 16#8230#;
   GL_R8I                                             : constant := 16#8231#;
   GL_R8UI                                            : constant := 16#8232#;
   GL_R16I                                            : constant := 16#8233#;
   GL_R16UI                                           : constant := 16#8234#;
   GL_R32I                                            : constant := 16#8235#;
   GL_R32UI                                           : constant := 16#8236#;
   GL_RG8I                                            : constant := 16#8237#;
   GL_RG8UI                                           : constant := 16#8238#;
   GL_RG16I                                           : constant := 16#8239#;
   GL_RG16UI                                          : constant := 16#823a#;
   GL_RG32I                                           : constant := 16#823b#;
   GL_RG32UI                                          : constant := 16#823c#;
   GL_VERTEX_ARRAY_BINDING                            : constant := 16#85b5#;
   GL_UNIFORM_BUFFER                                  : constant := 16#8a11#;
   GL_UNIFORM_BUFFER_BINDING                          : constant := 16#8a28#;
   GL_UNIFORM_BUFFER_START                            : constant := 16#8a29#;
   GL_UNIFORM_BUFFER_SIZE                             : constant := 16#8a2a#;
   GL_MAX_VERTEX_UNIFORM_BLOCKS                       : constant := 16#8a2b#;
   GL_MAX_GEOMETRY_UNIFORM_BLOCKS                     : constant := 16#8a2c#;
   GL_MAX_FRAGMENT_UNIFORM_BLOCKS                     : constant := 16#8a2d#;
   GL_MAX_COMBINED_UNIFORM_BLOCKS                     : constant := 16#8a2e#;
   GL_MAX_UNIFORM_BUFFER_BINDINGS                     : constant := 16#8a2f#;
   GL_MAX_UNIFORM_BLOCK_SIZE                          : constant := 16#8a30#;
   GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS          : constant := 16#8a31#;
   GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS        : constant := 16#8a32#;
   GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS        : constant := 16#8a33#;
   GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT                 : constant := 16#8a34#;
   GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH            : constant := 16#8a35#;
   GL_ACTIVE_UNIFORM_BLOCKS                           : constant := 16#8a36#;
   GL_UNIFORM_TYPE                                    : constant := 16#8a37#;
   GL_UNIFORM_SIZE                                    : constant := 16#8a38#;
   GL_UNIFORM_NAME_LENGTH                             : constant := 16#8a39#;
   GL_UNIFORM_BLOCK_INDEX                             : constant := 16#8a3a#;
   GL_UNIFORM_OFFSET                                  : constant := 16#8a3b#;
   GL_UNIFORM_ARRAY_STRIDE                            : constant := 16#8a3c#;
   GL_UNIFORM_MATRIX_STRIDE                           : constant := 16#8a3d#;
   GL_UNIFORM_IS_ROW_MAJOR                            : constant := 16#8a3e#;
   GL_UNIFORM_BLOCK_BINDING                           : constant := 16#8a3f#;
   GL_UNIFORM_BLOCK_DATA_SIZE                         : constant := 16#8a40#;
   GL_UNIFORM_BLOCK_NAME_LENGTH                       : constant := 16#8a41#;
   GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS                   : constant := 16#8a42#;
   GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES            : constant := 16#8a43#;
   GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER       : constant := 16#8a44#;
   GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER     : constant := 16#8a45#;
   GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER     : constant := 16#8a46#;
   GL_INVALID_INDEX                                   : aliased constant
     C.unsigned := 16#ffffffff#;
   GL_COPY_READ_BUFFER                                : constant := 16#8f36#;
   GL_COPY_WRITE_BUFFER                               : constant := 16#8f37#;
   GL_DEPTH_CLAMP                                     : constant := 16#864f#;
   GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION        : constant := 16#8e4c#;
   GL_FIRST_VERTEX_CONVENTION                         : constant := 16#8e4d#;
   GL_LAST_VERTEX_CONVENTION                          : constant := 16#8e4e#;
   GL_PROVOKING_VERTEX                                : constant := 16#8e4f#;
   GL_TEXTURE_CUBE_MAP_SEAMLESS                       : constant := 16#884f#;
   GL_MAX_SERVER_WAIT_TIMEOUT                         : constant := 16#9111#;
   GL_OBJECT_TYPE                                     : constant := 16#9112#;
   GL_SYNC_CONDITION                                  : constant := 16#9113#;
   GL_SYNC_STATUS                                     : constant := 16#9114#;
   GL_SYNC_FLAGS                                      : constant := 16#9115#;
   GL_SYNC_FENCE                                      : constant := 16#9116#;
   GL_SYNC_GPU_COMMANDS_COMPLETE                      : constant := 16#9117#;
   GL_UNSIGNALED                                      : constant := 16#9118#;
   GL_SIGNALED                                        : constant := 16#9119#;
   GL_ALREADY_SIGNALED                                : constant := 16#911a#;
   GL_TIMEOUT_EXPIRED                                 : constant := 16#911b#;
   GL_CONDITION_SATISFIED                             : constant := 16#911c#;
   GL_WAIT_FAILED                                     : constant := 16#911d#;
   GL_SYNC_FLUSH_COMMANDS_BIT                         : constant := 16#1#;
   GL_TIMEOUT_IGNORED                                 : constant :=
     16#ffffffffffffffff#;
   GL_SAMPLE_POSITION                                 : constant := 16#8e50#;
   GL_SAMPLE_MASK                                     : constant := 16#8e51#;
   GL_SAMPLE_MASK_VALUE                               : constant := 16#8e52#;
   GL_MAX_SAMPLE_MASK_WORDS                           : constant := 16#8e59#;
   GL_TEXTURE_2D_MULTISAMPLE                          : constant := 16#9100#;
   GL_PROXY_TEXTURE_2D_MULTISAMPLE                    : constant := 16#9101#;
   GL_TEXTURE_2D_MULTISAMPLE_ARRAY                    : constant := 16#9102#;
   GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY              : constant := 16#9103#;
   GL_TEXTURE_BINDING_2D_MULTISAMPLE                  : constant := 16#9104#;
   GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY            : constant := 16#9105#;
   GL_TEXTURE_SAMPLES                                 : constant := 16#9106#;
   GL_TEXTURE_FIXED_SAMPLE_LOCATIONS                  : constant := 16#9107#;
   GL_SAMPLER_2D_MULTISAMPLE                          : constant := 16#9108#;
   GL_INT_SAMPLER_2D_MULTISAMPLE                      : constant := 16#9109#;
   GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE             : constant := 16#910a#;
   GL_SAMPLER_2D_MULTISAMPLE_ARRAY                    : constant := 16#910b#;
   GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY                : constant := 16#910c#;
   GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY       : constant := 16#910d#;
   GL_MAX_COLOR_TEXTURE_SAMPLES                       : constant := 16#910e#;
   GL_MAX_DEPTH_TEXTURE_SAMPLES                       : constant := 16#910f#;
   GL_MAX_INTEGER_SAMPLES                             : constant := 16#9110#;
   GL_SAMPLE_SHADING                                  : constant := 16#8c36#;
   GL_MIN_SAMPLE_SHADING_VALUE                        : constant := 16#8c37#;
   GL_TEXTURE_CUBE_MAP_ARRAY                          : constant := 16#9009#;
   GL_TEXTURE_BINDING_CUBE_MAP_ARRAY                  : constant := 16#900a#;
   GL_PROXY_TEXTURE_CUBE_MAP_ARRAY                    : constant := 16#900b#;
   GL_SAMPLER_CUBE_MAP_ARRAY                          : constant := 16#900c#;
   GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW                   : constant := 16#900d#;
   GL_INT_SAMPLER_CUBE_MAP_ARRAY                      : constant := 16#900e#;
   GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY             : constant := 16#900f#;
   GL_SRC1_COLOR                                      : constant := 16#88f9#;
   GL_ONE_MINUS_SRC1_COLOR                            : constant := 16#88fa#;
   GL_ONE_MINUS_SRC1_ALPHA                            : constant := 16#88fb#;
   GL_MAX_DUAL_SOURCE_DRAW_BUFFERS                    : constant := 16#88fc#;
   GL_ANY_SAMPLES_PASSED                              : constant := 16#8c2f#;
   GL_SAMPLER_BINDING                                 : constant := 16#8919#;
   GL_RGB10_A2UI                                      : constant := 16#906f#;
   GL_TEXTURE_SWIZZLE_R                               : constant := 16#8e42#;
   GL_TEXTURE_SWIZZLE_G                               : constant := 16#8e43#;
   GL_TEXTURE_SWIZZLE_B                               : constant := 16#8e44#;
   GL_TEXTURE_SWIZZLE_A                               : constant := 16#8e45#;
   GL_TEXTURE_SWIZZLE_RGBA                            : constant := 16#8e46#;
   GL_TIME_ELAPSED                                    : constant := 16#88bf#;
   GL_TIMESTAMP                                       : constant := 16#8e28#;
   GL_INT_2_10_10_10_REV                              : constant := 16#8d9f#;
   GL_DRAW_INDIRECT_BUFFER                            : constant := 16#8f3f#;
   GL_DRAW_INDIRECT_BUFFER_BINDING                    : constant := 16#8f43#;
   GL_GEOMETRY_SHADER_INVOCATIONS                     : constant := 16#887f#;
   GL_MAX_GEOMETRY_SHADER_INVOCATIONS                 : constant := 16#8e5a#;
   GL_MIN_FRAGMENT_INTERPOLATION_OFFSET               : constant := 16#8e5b#;
   GL_MAX_FRAGMENT_INTERPOLATION_OFFSET               : constant := 16#8e5c#;
   GL_FRAGMENT_INTERPOLATION_OFFSET_BITS              : constant := 16#8e5d#;
   GL_DOUBLE_VEC2                                     : constant := 16#8ffc#;
   GL_DOUBLE_VEC3                                     : constant := 16#8ffd#;
   GL_DOUBLE_VEC4                                     : constant := 16#8ffe#;
   GL_DOUBLE_MAT2                                     : constant := 16#8f46#;
   GL_DOUBLE_MAT3                                     : constant := 16#8f47#;
   GL_DOUBLE_MAT4                                     : constant := 16#8f48#;
   GL_DOUBLE_MAT2x3                                   : constant := 16#8f49#;
   GL_DOUBLE_MAT2x4                                   : constant := 16#8f4a#;
   GL_DOUBLE_MAT3x2                                   : constant := 16#8f4b#;
   GL_DOUBLE_MAT3x4                                   : constant := 16#8f4c#;
   GL_DOUBLE_MAT4x2                                   : constant := 16#8f4d#;
   GL_DOUBLE_MAT4x3                                   : constant := 16#8f4e#;
   GL_ACTIVE_SUBROUTINES                              : constant := 16#8de5#;
   GL_ACTIVE_SUBROUTINE_UNIFORMS                      : constant := 16#8de6#;
   GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS             : constant := 16#8e47#;
   GL_ACTIVE_SUBROUTINE_MAX_LENGTH                    : constant := 16#8e48#;
   GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH            : constant := 16#8e49#;
   GL_MAX_SUBROUTINES                                 : constant := 16#8de7#;
   GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS                : constant := 16#8de8#;
   GL_NUM_COMPATIBLE_SUBROUTINES                      : constant := 16#8e4a#;
   GL_COMPATIBLE_SUBROUTINES                          : constant := 16#8e4b#;
   GL_PATCHES                                         : constant := 16#e#;
   GL_PATCH_VERTICES                                  : constant := 16#8e72#;
   GL_PATCH_DEFAULT_INNER_LEVEL                       : constant := 16#8e73#;
   GL_PATCH_DEFAULT_OUTER_LEVEL                       : constant := 16#8e74#;
   GL_TESS_CONTROL_OUTPUT_VERTICES                    : constant := 16#8e75#;
   GL_TESS_GEN_MODE                                   : constant := 16#8e76#;
   GL_TESS_GEN_SPACING                                : constant := 16#8e77#;
   GL_TESS_GEN_VERTEX_ORDER                           : constant := 16#8e78#;
   GL_TESS_GEN_POINT_MODE                             : constant := 16#8e79#;
   GL_ISOLINES                                        : constant := 16#8e7a#;
   GL_FRACTIONAL_ODD                                  : constant := 16#8e7b#;
   GL_FRACTIONAL_EVEN                                 : constant := 16#8e7c#;
   GL_MAX_PATCH_VERTICES                              : constant := 16#8e7d#;
   GL_MAX_TESS_GEN_LEVEL                              : constant := 16#8e7e#;
   GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS             : constant := 16#8e7f#;
   GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS          : constant := 16#8e80#;
   GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS            : constant := 16#8e81#;
   GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS         : constant := 16#8e82#;
   GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS              : constant := 16#8e83#;
   GL_MAX_TESS_PATCH_COMPONENTS                       : constant := 16#8e84#;
   GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS        : constant := 16#8e85#;
   GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS           : constant := 16#8e86#;
   GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS                 : constant := 16#8e89#;
   GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS              : constant := 16#8e8a#;
   GL_MAX_TESS_CONTROL_INPUT_COMPONENTS               : constant := 16#886c#;
   GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS            : constant := 16#886d#;
   GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS    : constant := 16#8e1e#;
   GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS : constant := 16#8e1f#;
   GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER : constant := 16#84f0#;
   GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER : constant := 16#84f1#;
   GL_TESS_EVALUATION_SHADER                          : constant := 16#8e87#;
   GL_TESS_CONTROL_SHADER                             : constant := 16#8e88#;
   GL_TRANSFORM_FEEDBACK                              : constant := 16#8e22#;
   GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED                : constant := 16#8e23#;
   GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE                : constant := 16#8e24#;
   GL_TRANSFORM_FEEDBACK_BINDING                      : constant := 16#8e25#;
   GL_MAX_TRANSFORM_FEEDBACK_BUFFERS                  : constant := 16#8e70#;
   GL_MAX_VERTEX_STREAMS                              : constant := 16#8e71#;
   GL_FILTER4_SGIS                                    : constant := 16#8146#;
   GL_TEXTURE_FILTER4_SIZE_SGIS                       : constant := 16#8147#;

end GLext;
