#version 330 core

layout(location = 0) in vec3 vertexPosition_modelspace;
layout(location = 1) in vec2 vertexUV;

out vec2 UV;

uniform mat4 MVP;
uniform float mytime;

// in this case, wPos indicates the center of
// the orbit of the fish:
uniform vec3 wPos;

uniform int RotSense; // +1=> CW,  -1=> CCW;

uniform float rad; //radius of swim circle (fish:1, shark:11)
uniform float svel; // swim-velocity (nom=1.0)
uniform float wvel; // wiggle-velocity (nom=1.0)
uniform float wamp; // wiggle-amplitude (nom=1.0)

const float onepi = 3.14159;


float wrad( float ang )
{
	//25 wiggles per twopi swim around unit radius
	float dr = wamp*0.005*sin(sqrt(rad)*wvel*25*ang)/sqrt(rad); 
	return rad*(1+dr);
}

// wiggle component of final radius as ftn of Z-offset
float zwrad( float ang, float dz )
{
	float dang = atan(dz/rad);
	return wrad(ang+dang);
}


// note:  all fish have Z as long dimension...
//        stingray has fdy=0, others have fdx=0

void main(){


	float ang = svel*0.05*mytime*onepi;

	vec3 pos = vertexPosition_modelspace;
	if( RotSense<0 )
	{
		ang *= -1.0;
		pos.z *= -1.0;
		pos.x *= -1.0;
	}
	pos.x += wPos.x;
	pos.y += wPos.y;
	pos.z += wPos.z;
	// we assume original setup @ origin

	// original vector of current pt from center:
	float ddx = pos.x - wPos.x;
	float ddz = pos.z - wPos.z;
	float ddy = pos.y - wPos.y;

	// rotated vector of pt from center:
	float ddxx = +cos(ang)*ddx - sin(ang)*ddz;
	float ddzz = +sin(ang)*ddx + cos(ang)*ddz;

	// rotate fish to match tangent of swim circle:
	pos.x = wPos.x + ddxx;
	pos.z = wPos.z + ddzz;

	float zdr = zwrad(ang,ddz);

	// this displaces entire fish to swim in circle:
	pos.x = pos.x + zdr*cos(ang);
	pos.z = pos.z + zdr*sin(ang);


	gl_Position =  MVP * vec4(pos,1.0);
	UV = vertexUV; 
}

