#!/bin/sh
#
# Mac OS-X compile script for GNAT2015
# ...this script should work on any recent
# standard configuration of OS-X so long as
# the 2015 GNU Ada compiler, gnatmake, is installed.
#
# important note:
# on linux, gcc requires libstdc++ but here on OSX,
# gcc == clang++, which requires libc++

#################################################
# prepare snd4ada.o file prior to gnatmake

g++ snd4ada.cpp -c -Werror -fPIC -I./include

mv snd4ada.o ./obj/

##################################################

gnatmake  adagate -O3  \
-o adagate_osx \
--subdirs=./obj \
-I$PWD/adabindings/gl \
-I$PWD/adabindings/sdlada \
-I$PWD/adabindings/AdaPngLib \
-largs -lm -lz \
-lc++ \
snd4ada.o \
$PWD/osxlibs/libSDL2.a \
$PWD/osxlibs/libiconv.a \
$PWD/osxlibs/libsfml-audio-s.a \
$PWD/osxlibs/libsfml-system-s.a \
$PWD/osxlibs/libsndfile.a \
\
-framework OpenGL \
-framework ForceFeedback \
-framework CoreFoundation \
-framework Carbon \
-framework Cocoa \
-framework QuartzCore \
-framework IOKit \
-framework CoreAudio \
-framework AudioUnit \
-framework OpenAL \
-pthread

cp ./obj/adagate_osx .



# -- Copyright (C) 2016  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.

