# Linux
#
# This script probably produces the most
# portable linux executable binary...
#
# static:  SDL2 v2.0.3  &  SFML v2.1
# shared:  FLAC,ogg,vorbis,openal
#
# uses rpath to tell runtime linker to look also in
# ./gnulibs/ for any needed *.so files not found elsewhere
#
# library presence in linux distros:
# 56/77	FLAC   => 73%
# 75/77	ogg
# 22/77	openal => most rare @ 28%
# 76/77	vorbis

#########################################################
# prepares snd4ada.o file prior to gnatmake

g++ snd4ada.cpp -c -Werror -fPIC -I./include

mv snd4ada.o ./obj/

#########################################################

# this is the typical path of gnat gpl 2015 (20150428):
export PATH=/usr/gnat/bin:$PATH


gnatmake adagate -o adagate_gnu \
-O3 -gnat12 \
--subdirs=./obj \
-I./adabindings/gl \
-I./adabindings/sdlada \
-I./adabindings/AdaPngLib \
-largs \
-lGL -lz -lstdc++ \
$PWD/gnulibs/libSDL2.a -lm -lpthread -ldl \
$PWD/gnulibs/libsfml-audio-s.a \
$PWD/gnulibs/libsfml-system-s.a \
$PWD/gnulibs/libsndfile.a \
\
-Wl,-rpath,'$ORIGIN/gnulibs' \
-L$PWD/gnulibs \
-lFLAC -logg -lvorbis -lvorbisenc -lopenal \
\
snd4ada.o

cp ./obj/adagate_gnu .


# -- Copyright (C) 2016  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.



