
--
-- Copyright (C) 2016  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--

with system;
with gl, gl.binding, gl.pointers;
with glu, glu.binding, glu.pointers;
with glext, glext.binding, glext.pointers;

with interfaces.c;
use type interfaces.c.unsigned_short;

with ada.finalization;
with unchecked_deallocation;

	with text_io;




package body usboxobj is -- unit skybox (epilog)





procedure initialize( us: in out unitsky ) is
begin
	us.vert := new varray;
	us.elem := new earray;
end initialize;

procedure vfree is new unchecked_deallocation(varray,vap);
procedure efree is new unchecked_deallocation(earray,eap);

procedure finalize( us: in out unitsky ) is
begin
	vfree( us.vert );
	efree( us.elem );
	--text_io.put_line("usbox Free");
end finalize;








procedure setrect( us: unitsky; sx,sy,sz: float ) is

	-- sz = horizontal radius 30nov14

	xm : float := -sx;
	xp : float := +sx;
	ym : float := -sy;
	yp : float := +sy;
	zm : float := -sz;
	zp : float := +sz;

	j,k : integer := 0;
	jj : glushort := 0;

begin

	-- front
	us.vert(k+ 1):=xm;  us.vert(k+ 2):=ym;  us.vert(k+ 3):=zp;
	us.vert(k+ 4):=xm;  us.vert(k+ 5):=yp;  us.vert(k+ 6):=zp;
	us.vert(k+ 7):=xp;  us.vert(k+ 8):=yp;  us.vert(k+ 9):=zp;
	us.vert(k+10):=xp;  us.vert(k+11):=ym;  us.vert(k+12):=zp;
	k:=k+12;

	-- top
	us.vert(k+ 1):=xm;  us.vert(k+ 2):=yp;  us.vert(k+ 3):=zp;
	us.vert(k+ 4):=xm;  us.vert(k+ 5):=yp;  us.vert(k+ 6):=zm;
	us.vert(k+ 7):=xp;  us.vert(k+ 8):=yp;  us.vert(k+ 9):=zm;
	us.vert(k+10):=xp;  us.vert(k+11):=yp;  us.vert(k+12):=zp;
	k:=k+12;


	-- back
	us.vert(k+ 1):=xp;  us.vert(k+ 2):=ym;  us.vert(k+ 3):=zm;
	us.vert(k+ 4):=xp;  us.vert(k+ 5):=yp;  us.vert(k+ 6):=zm;
	us.vert(k+ 7):=xm;  us.vert(k+ 8):=yp;  us.vert(k+ 9):=zm;
	us.vert(k+10):=xm;  us.vert(k+11):=ym;  us.vert(k+12):=zm;
	k:=k+12;

	-- bottom
	us.vert(k+ 1):=xm;  us.vert(k+ 2):=ym;  us.vert(k+ 3):=zm;
	us.vert(k+ 4):=xm;  us.vert(k+ 5):=ym;  us.vert(k+ 6):=zp;
	us.vert(k+ 7):=xp;  us.vert(k+ 8):=ym;  us.vert(k+ 9):=zp;
	us.vert(k+10):=xp;  us.vert(k+11):=ym;  us.vert(k+12):=zm;
	k:=k+12;


	-- right
	us.vert(k+ 1):=xm;  us.vert(k+ 2):=ym;  us.vert(k+ 3):=zm;
	us.vert(k+ 4):=xm;  us.vert(k+ 5):=yp;  us.vert(k+ 6):=zm;
	us.vert(k+ 7):=xm;  us.vert(k+ 8):=yp;  us.vert(k+ 9):=zp;
	us.vert(k+10):=xm;  us.vert(k+11):=ym;  us.vert(k+12):=zp;
	k:=k+12;

	-- left
	us.vert(k+ 1):=xp;  us.vert(k+ 2):=ym;  us.vert(k+ 3):=zp;
	us.vert(k+ 4):=xp;  us.vert(k+ 5):=yp;  us.vert(k+ 6):=zp;
	us.vert(k+ 7):=xp;  us.vert(k+ 8):=yp;  us.vert(k+ 9):=zm;
	us.vert(k+10):=xp;  us.vert(k+11):=ym;  us.vert(k+12):=zm;



	-- element indices:
	for i in 0..5 loop
		jj:=glushort(i*4);
		j := i*6;
		us.elem(j+1):=jj+0;
		us.elem(j+2):=jj+1;
		us.elem(j+3):=jj+2;
		us.elem(j+4):=jj+2;
		us.elem(j+5):=jj+3;
		us.elem(j+6):=jj+0;
	end loop;


end setrect;



-- note:  the shaders for these objects must have one
-- input "layout", as well as whatever uniforms are needed:
--
-- layout(location=0) in vec3 vertPosName
--
-- ...where their actual name can be whatever is convenient
--

use gl;
use glext;
use glext.binding;
use gl.binding;

procedure draw( us: unitsky;  vertbuff, elembuff : gluint ) is
begin

	-- 0th attribute:  vertices
	glBindBuffer(gl_array_buffer, vertbuff);
	glBufferData(gl_array_buffer, glsizeiptr(4*nvert), us.vert(1)'address, gl_static_draw);
	glEnableVertexAttribArray(0);
	glVertexAttribPointer(0,3,gl_float,gl_false,0, system.null_address);

	-- element indices:
	glBindBuffer(gl_element_array_buffer, elembuff);
	glBufferData(gl_element_array_buffer, glsizeiptr(2*nelm), us.elem(1)'address, gl_static_draw);

	glDrawElements( gl_triangles, glint(nvert), gl_unsigned_short, system.null_address );

	glDisableVertexAttribArray(0);

end draw;



end usboxobj;

