#version 330 core

//
// Opacity that was determined purely from LOS-slant-range
// thru the water failed during my flyover cutscene.
//
// I am now leaning toward more simplistic opacity
// algorithm based mostly on depth.
//
// Also, I was unhappy with formal fresnel formula.  A
// simplified version seems better to me.
//

in float depth; // depth>=0 (input from vert.shader)

const float deep = 10.0; //slantdepth of maximal opacity
// note:  max radius = 20


in float wlev;

in vec2 waveDirection;

in vec3 position;
in vec3 worldNormal;

out vec4 color;

uniform vec3 eyePos; // virtual (pos wrt island sand)

uniform samplerCube envMap;



////////////// begin insert /////////////////

uniform float mytime;


float fizz( vec2 p, vec2 t ) {

	float time = mytime*2.0;
	float phase = 2.0*t.x + 2.0*t.y; //definite improvement...phase-offset

	float col = 0.0;
	float c=0.0;
	c+=cos(p.x*80.0+time*3.0)*cos(p.y*60.0+cos(time*p.x*0.6+time*2.0)+time*3.0);
	c+=cos(p.y*70.0+time*1.2)*cos(p.x*70.0+cos(time*p.y*0.4+time*1.2)+time*1.5);
	c+=cos(p.y*90.0+time*2.0)*cos(p.y*50.0+cos(time*p.x*0.3+time*1.2)+time*2.5);
	col = cos(c+time+phase);

	col = 0.25*col + 0.75;

	return col;

} // end fizz


const float maxamp=0.03; //  0.03 ~= sum_ampl. of waterwaves

////////////// end insert /////////////////




void main(){

	vec2 uv = vec2( position.x, position.z );
	float radius = length(uv); // r1=5, lagoonRad=3
	vec2 UV = fract( uv ); // now, both in [0..1)


	// set variable threshold for deep water foam:
	float e = 1.0 + 0.8*length(uv); // more foam far away
	float thresh = wlev + 7.0*maxamp / e; // deep water foam above this Ypos

	vec3 wavdir = vec3( waveDirection.x, 0, waveDirection.y );
	vec3 wnrm = vec3( worldNormal.x, 0, worldNormal.z );
	float dprod = dot( normalize(wnrm), wavdir ); // dprod=-1 => back of wave

   vec3 eyeraw = (position-eyePos);
   vec3 eye = normalize(eyeraw);
   vec3 r = reflect(eye, worldNormal);
  	vec4 precolor = texture(envMap, r);


	float odeep;
	// depth-based opacity: a compromise
	if( depth>0.22 ) odeep=0.88;
	else odeep = depth*4;
	if( radius > 13 ) odeep=0.99;
	else if( radius > 12 ) odeep += (radius-12)*0.11;

	odeep = odeep*odeep;


	// mimic fresnel affect by adjusting opacity
	// higher at high grazing angles:
	float dota = dot(worldNormal,eye); // cos of angle between eye, normal
	float ofac = abs(dota);
	ofac=ofac*ofac;
	// idea: ofac in 0..1, 1=>no additional opac, 0=>very opaque
	float opac = ofac*odeep + (1-ofac)*0.95;

	//opac = odeep; // test pure odeep value

///////// opacity above here /////////////////////////////////////////


////////// hue adjustment below ////////////////////////////////////////

	// fine hue adjustment to add green near shallows...

	// weight=1.0; => all blue  ...  weight=0.0; => all green
	float weight = 0.5 + radius/20; // all blue beyond rad=10
	if( weight<0.8 ) weight=0.8;
	if ( weight > 1.0 ) weight = 1.0;
	vec4 green=vec4(0.4, 0.9, 0.4, 1.0);
	vec4 watercolor = mix( green, precolor, weight ); // wt = amt of precolor

	color = watercolor;
	color.rgb *= 0.9; // subdue the somewhat oversaturated colors


	// make colors even darker near lagoon center:
	const float darkest = 0.5;
	if( radius < 4 ) 
	{
		color.rgb *= darkest + (1-darkest)*radius/4;
	}


	// finally, set opacity curve: //////////////////////////
  	//color.a = sqrt(sqrt(opac)); // opaque shallows
  	//color.a = sqrt(opac);
  	//color.a = opac;
  	color.a = opac*opac; // translucent shallows



// define foam below here ///////////////////////////////////////////////////
if( radius > 6 ) // rmax=20, r2=7@ surfline, r1=5@ maxht, lagoonRad=3..3.5
{

	if( depth <= 0.0002 ) // remember, depth might be negative
	{

		// coarser foam at shoreline
		float fuv = fizz(UV*1.0, uv); // 1.0 makes bigger bubbles
		float alpha=0.9;

		if( fuv < 0.9 ) 
			alpha=0.0; // make darker parts of fizz invisible
		else // this puts foam inside water edge...awesome if min opacity=0
			color = vec4( vec3( fuv ), alpha );

	}

	
	else
	if( (position.y>thresh) && (dprod<0) ) //deep water
	{

		// finer foam in deep [more distant] water
		float fuv = fizz(UV*4.0, uv); // 4.0 makes finer bubbles
		float alpha=0.9;
		vec4 fcolor = vec4( vec3(fuv), alpha ); // foam color
		if( fuv > 0.9 ) color = mix( fcolor, watercolor, 0.1 );

	}

} // end if radius>6


}

// this version has foam and depth-related opacity;
// plus depth-related greenish color
// plus wave-peak foam

//--
//-- Copyright (C) 2016  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

