/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXSplit;

final class BaseXSplitSep
extends BaseXBack {
    private final boolean horizontal;

    BaseXSplitSep(boolean horizontal) {
        this.setCursor(horizontal ? GUIConstants.CURSORMOVEH : GUIConstants.CURSORMOVEV);
        MouseInputAdapter mouse = new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ((BaseXSplit)BaseXSplitSep.this.getParent()).startDrag(BaseXSplitSep.this.pos(e));
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                ((BaseXSplit)BaseXSplitSep.this.getParent()).drag(BaseXSplitSep.this, BaseXSplitSep.this.pos(e));
            }
        };
        this.addMouseListener(mouse);
        this.addMouseMotionListener(mouse);
        this.horizontal = horizontal;
    }

    @Override
    public void paintComponent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(GUIConstants.PANEL);
        g.fillRect(0, 0, w, h);
        g.setColor(GUIConstants.gray);
        g.drawLine(0, 0, this.horizontal ? 0 : w, this.horizontal ? h : 0);
        g.drawLine(this.horizontal ? w - 1 : 0, this.horizontal ? 0 : h - 1, this.horizontal ? w - 1 : w, this.horizontal ? h : h - 1);
    }

    private double pos(MouseEvent e) {
        Point p = this.getLocationOnScreen();
        return this.horizontal ? (double)(p.x + e.getX()) : (double)(p.y + e.getY());
    }
}

