/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Stack;
import java.util.StringTokenizer;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXImages;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewComponent;
import org.basex.gui.view.ViewLayout;
import org.basex.gui.view.ViewPanel;
import org.basex.util.Strings;
import org.basex.util.Util;

public final class ViewContainer
extends BaseXBack {
    private static final BasicStroke STROKE = new BasicStroke(2.0f);
    private final GUI gui;
    private final ViewPanel[] views;
    private final int[] pos = new int[4];
    private final Image logo;
    private ViewLayout layout;
    private String layoutString;
    private ViewPanel source;
    private ViewPanel target;
    private Location location;
    private Point sp;

    public ViewContainer(GUI gui, View ... view) {
        this.layout(new BorderLayout());
        this.setBackground(GUIConstants.BACK);
        this.gui = gui;
        this.logo = BaseXImages.get("logo_256");
        int vl = view.length;
        this.views = new ViewPanel[vl];
        for (int v = 0; v < vl; ++v) {
            this.views[v] = new ViewPanel(view[v]);
        }
        if (!this.buildLayout(gui.gopts.get(GUIOptions.VIEWS)) && !this.buildLayout("V H editor folder map plot  - H text info table tree explore - -")) {
            Util.errln(Util.className(this) + ": could not build layout.", new Object[0]);
        }
    }

    public void updateViews() {
        this.layout.setVisibility(this.gui.context.data() != null);
        String ls = this.layout.layoutString(false);
        if (ls.equals(this.layoutString)) {
            return;
        }
        this.gui.gopts.set(GUIOptions.VIEWS, this.layout.layoutString(true));
        this.layoutString = ls;
        this.removeAll();
        this.layout.addTo(this);
        this.validate();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getComponentCount() == 0) {
            g.drawImage(this.logo, (this.getWidth() - this.logo.getWidth(this)) / 2, (this.getHeight() - this.logo.getHeight(this)) / 2, this);
        }
    }

    void dragPanel(ViewPanel panel, Point p) {
        this.source = panel;
        this.sp = p;
        this.calc();
        this.repaint();
    }

    void dropPanel() {
        if (this.source == null) {
            return;
        }
        if (this.location != null) {
            ViewComponent comp = this.layout.delete(this.source);
            if (comp instanceof ViewLayout) {
                this.layout = (ViewLayout)comp;
            }
            if (this.target == null) {
                this.layout = this.addView(this.layout);
            } else {
                this.add(this.layout);
            }
            this.updateViews();
        }
        this.source = null;
        this.repaint();
    }

    private boolean add(ViewLayout vl) {
        for (int c = 0; c < vl.list.size(); ++c) {
            boolean east;
            ViewComponent comp = vl.list.get(c);
            if (comp instanceof ViewLayout) {
                if (!this.add((ViewLayout)comp)) continue;
                return true;
            }
            if (comp != this.target) continue;
            boolean west = this.location == Location.WEST;
            boolean bl = east = this.location == Location.EAST;
            if (this.location == Location.NORTH || west) {
                if (vl.horizontal == west) {
                    vl.insert(this.source, c);
                } else {
                    vl.set(new ViewLayout(west, this.source, this.target), c);
                }
            } else if (this.location == Location.SOUTH || east) {
                if (vl.horizontal == east) {
                    vl.insert(this.source, c + 1);
                } else {
                    vl.set(new ViewLayout(east, this.target, this.source), c);
                }
            }
            return true;
        }
        return false;
    }

    private ViewLayout addView(ViewLayout vl) {
        boolean west = this.location == Location.WEST;
        boolean east = this.location == Location.EAST;
        ViewLayout l = vl;
        if (this.location == Location.NORTH || west) {
            if (l.horizontal == west) {
                l.insert(this.source, 0);
            } else {
                l = new ViewLayout(west, this.source, l);
            }
        } else if (this.location == Location.SOUTH || east) {
            if (l.horizontal == east) {
                l.add(this.source);
            } else {
                l = new ViewLayout(east, l, this.source);
            }
        }
        return l;
    }

    private ViewPanel getTarget() {
        for (ViewPanel view : this.views) {
            if (!view.isVisible() || !new Rectangle(this.absLoc(view), view.getSize()).contains(this.sp)) continue;
            return view;
        }
        return null;
    }

    private Point absLoc(Component comp) {
        Component c = comp;
        Point p = c.getLocation();
        do {
            c = c.getParent();
            p.x += c.getX();
            p.y += c.getY();
        } while (c.getParent() != this);
        return p;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.source == null) {
            return;
        }
        ((Graphics2D)g).setStroke(STROKE);
        if (this.location != null) {
            g.setColor(GUIConstants.dgray);
            g.drawRect(this.pos[0], this.pos[1], this.pos[2] - 1, this.pos[3] - 1);
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.5f));
            g.setColor(GUIConstants.lgray);
            g.fillRect(this.pos[0], this.pos[1], this.pos[2], this.pos[3]);
        }
    }

    private void calc() {
        int hh = this.getHeight();
        int ww = this.getWidth();
        this.pos[0] = 1;
        this.pos[1] = 1;
        this.pos[2] = ww - 2;
        this.pos[3] = hh - 2;
        this.location = null;
        this.target = this.getTarget();
        if (this.target != null && this.target != this.source) {
            Rectangle tr = new Rectangle(this.absLoc(this.target), this.target.getSize());
            int minx = tr.width >> 1;
            int miny = tr.height >> 1;
            if (Math.abs(tr.x + tr.width / 2 - this.sp.x) < tr.width / 3) {
                if (this.sp.y > tr.y && this.sp.y < tr.y + miny) {
                    this.pos[0] = tr.x;
                    this.pos[1] = tr.y;
                    this.pos[2] = tr.width;
                    this.pos[3] = miny;
                    this.location = Location.NORTH;
                } else if (this.sp.y > tr.y + tr.height - miny && this.sp.y < tr.y + tr.height) {
                    this.pos[0] = tr.x;
                    this.pos[1] = tr.y + tr.height - miny;
                    this.pos[2] = tr.width;
                    this.pos[3] = miny;
                    this.location = Location.SOUTH;
                }
            } else if (Math.abs(tr.y + tr.height / 2 - this.sp.y) < tr.height / 3) {
                if (this.sp.x > tr.x && this.sp.x < tr.x + minx) {
                    this.pos[0] = tr.x;
                    this.pos[1] = tr.y;
                    this.pos[2] = minx;
                    this.pos[3] = tr.height;
                    this.location = Location.WEST;
                } else if (this.sp.x > tr.x + tr.width - minx && this.sp.x < tr.x + tr.width) {
                    this.pos[0] = tr.x + tr.width - minx;
                    this.pos[1] = tr.y;
                    this.pos[2] = minx;
                    this.pos[3] = tr.height;
                    this.location = Location.EAST;
                }
            }
        }
        if (this.location == null) {
            int minx = ww >> 2;
            int miny = hh >> 2;
            this.target = null;
            if (this.sp.y < miny) {
                this.pos[3] = miny;
                this.location = Location.NORTH;
            } else if (this.sp.y > hh - miny) {
                this.pos[3] = miny;
                this.pos[1] = hh - miny;
                this.location = Location.SOUTH;
            } else if (this.sp.x < minx) {
                this.pos[2] = minx;
                this.location = Location.WEST;
            } else if (this.sp.x > ww - minx) {
                this.pos[2] = minx;
                this.pos[0] = ww - minx;
                this.location = Location.EAST;
            }
        }
    }

    private boolean buildLayout(String string) {
        try {
            this.layout = null;
            int nv = 0;
            Stack<ViewPanel> layouts = new Stack<ViewPanel>();
            StringTokenizer tokens = new StringTokenizer(string);
            while (tokens.hasMoreTokens()) {
                ViewComponent view;
                String token = tokens.nextToken();
                if (Strings.eq(token, "H", "V")) {
                    view = new ViewLayout("H".equals(token), new ViewComponent[0]);
                    if (layouts.isEmpty()) {
                        this.layout = view;
                    } else {
                        ((ViewLayout)layouts.peek()).add(view);
                    }
                    layouts.add((ViewPanel)view);
                    continue;
                }
                if ("-".equals(token)) {
                    layouts.pop();
                    continue;
                }
                view = this.getView(token);
                if (view == null) {
                    return false;
                }
                ((ViewLayout)layouts.peek()).add(view);
                ++nv;
            }
            return nv == this.views.length;
        }
        catch (Exception ex) {
            Util.errln(ex, new Object[0]);
            return false;
        }
    }

    private ViewPanel getView(String name) {
        for (ViewPanel view : this.views) {
            if (!view.toString().equals(name)) continue;
            return view;
        }
        Util.debug(Util.className(this) + ": Unknown view \"%\"", name);
        return null;
    }

    private static enum Location {
        NORTH,
        WEST,
        EAST,
        SOUTH;

    }
}

