/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.function.Function;
import org.basex.query.CompileContext;
import org.basex.query.QueryException;
import org.basex.query.expr.And;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Or;
import org.basex.query.func.fn.FnBoolean;
import org.basex.query.func.fn.FnNot;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;

abstract class Logical
extends Arr {
    Logical(InputInfo info, Expr[] exprs) {
        super(info, SeqType.BLN_O, exprs);
    }

    @Override
    public final Expr compile(CompileContext cc) throws QueryException {
        int el = this.exprs.length;
        for (int e = 0; e < el; ++e) {
            try {
                this.exprs[e] = this.exprs[e].compile(cc);
                continue;
            }
            catch (QueryException qe) {
                if (e == 0) {
                    throw qe;
                }
                this.exprs[e] = cc.error(qe, this.exprs[e]);
            }
        }
        return this.optimize(cc);
    }

    public final Expr optimize(CompileContext cc, boolean and, Function<Expr[], Logical> negate) throws QueryException {
        ExprList list = new ExprList(this.exprs.length);
        for (Expr expr : this.exprs) {
            Expr ex = expr.optimizeEbv(cc);
            if (and ? ex instanceof And : ex instanceof Or) {
                for (Expr exp : ((Logical)ex).exprs) {
                    list.add(exp);
                }
                cc.info("flatten nested %: %", this.description(), ex);
                continue;
            }
            if (ex instanceof Value) {
                cc.info("remove % from %", expr, this.description());
                if (!(ex.ebv(cc.qc, this.info).bool(this.info) ^ and)) continue;
                return Bln.get(!and);
            }
            list.add(ex);
        }
        if (list.isEmpty()) {
            return Bln.get(and);
        }
        this.exprs = (Expr[])list.finish();
        list = new ExprList(this.exprs.length);
        this.simplify(cc, list);
        if (list.size() == 1) {
            return cc.replaceWith(this, FnBoolean.get((Expr)list.get(0), this.info, cc.sc()));
        }
        for (Expr expr : this.exprs = (Expr[])list.finish()) {
            if (expr.isFunction(org.basex.query.func.Function.NOT)) continue;
            return this;
        }
        list = new ExprList(this.exprs.length);
        for (Expr expr : this.exprs) {
            list.add(((FnNot)expr).exprs[0]);
        }
        this.exprs = (Expr[])list.finish();
        Expr expr = negate.apply(this.exprs).optimize(cc);
        return cc.replaceWith(this, cc.function(org.basex.query.func.Function.NOT, this.info, expr));
    }

    abstract void simplify(CompileContext var1, ExprList var2) throws QueryException;

    @Override
    public final void markTailCalls(CompileContext cc) {
        Expr last = this.exprs[this.exprs.length - 1];
        if (last.seqType().eq(SeqType.BLN_O)) {
            last.markTailCalls(cc);
        }
    }

    @Override
    public Expr inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        boolean changed = false;
        int el = this.exprs.length;
        for (int e = 0; e < el; ++e) {
            try {
                Expr exp = this.exprs[e].inline(var, ex, cc);
                if (exp == null) continue;
                this.exprs[e] = exp;
                changed = true;
                continue;
            }
            catch (QueryException qe) {
                if (e == 0) {
                    throw qe;
                }
                Expr[] nw = new Expr[e + 1];
                System.arraycopy(this.exprs, 0, nw, 0, e);
                nw[e] = cc.error(qe, this);
                this.exprs = nw;
                changed = true;
                break;
            }
        }
        return changed ? this.optimize(cc) : null;
    }

    @Override
    public void plan(FElem plan) {
        FElem elem = this.planElem(new Object[0]);
        plan.add(elem);
        for (Expr expr : this.exprs) {
            expr.plan(elem);
        }
    }
}

