/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.ArrayList;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.TypeswitchGroup;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class Typeswitch
extends ParseExpr {
    private TypeswitchGroup[] groups;
    private Expr cond;

    public Typeswitch(InputInfo info, Expr cond, TypeswitchGroup[] groups) {
        super(info, SeqType.ITEM_ZM);
        this.cond = cond;
        this.groups = groups;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.cond);
        int gl = this.groups.length;
        Expr[] tmp = new Expr[gl];
        for (int g = 0; g < gl; ++g) {
            tmp[g] = this.groups[g].expr;
        }
        this.checkAllUp(tmp);
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        this.cond = this.cond.compile(cc);
        for (TypeswitchGroup tg : this.groups) {
            tg.compile(cc);
        }
        return this.optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        if (this.cond instanceof Value) {
            Value value = (Value)this.cond;
            for (TypeswitchGroup tg : this.groups) {
                if (!tg.matches(value)) continue;
                tg.opt(cc, value);
                return cc.replaceWith(this, tg.expr);
            }
        }
        ArrayList<SeqType> types = new ArrayList<SeqType>();
        ArrayList<TypeswitchGroup> newGroups = new ArrayList<TypeswitchGroup>(this.groups.length);
        for (TypeswitchGroup group : this.groups) {
            if (!group.removeTypes(cc, types)) continue;
            newGroups.add(group);
        }
        if (this.groups.length != newGroups.size()) {
            this.groups = newGroups.toArray(new TypeswitchGroup[newGroups.size()]);
        }
        TypeswitchGroup tg = this.groups[0];
        boolean eq = tg.var == null;
        int gl = this.groups.length;
        for (int g = 1; eq && g < gl; ++g) {
            eq = tg.expr.equals(this.groups[g].expr);
        }
        if (eq) {
            return cc.replaceWith(this, tg.expr);
        }
        SeqType st = this.groups[0].seqType();
        for (int g = 1; g < gl; ++g) {
            st = st.union(this.groups[g].seqType());
        }
        this.exprType.assign(st);
        return this;
    }

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        Value seq = this.cond.value(qc);
        for (TypeswitchGroup tg : this.groups) {
            Iter iter = tg.iter(qc, seq);
            if (iter == null) continue;
            return iter;
        }
        throw Util.notExpected();
    }

    @Override
    public boolean isVacuous() {
        for (TypeswitchGroup tg : this.groups) {
            if (tg.expr.isVacuous()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean has(Flag ... flags) {
        for (TypeswitchGroup tg : this.groups) {
            if (!tg.has(flags)) continue;
            return true;
        }
        return this.cond.has(flags);
    }

    @Override
    public boolean removable(Var var) {
        for (TypeswitchGroup tg : this.groups) {
            if (tg.removable(var)) continue;
            return false;
        }
        return this.cond.removable(var);
    }

    @Override
    public VarUsage count(Var var) {
        return this.cond.count(var).plus(VarUsage.maximum(var, this.groups));
    }

    @Override
    public Expr inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        boolean changed = Typeswitch.inlineAll(this.groups, var, ex, cc);
        Expr c = this.cond.inline(var, ex, cc);
        if (c != null) {
            changed = true;
            this.cond = c;
        }
        return changed ? this.optimize(cc) : null;
    }

    @Override
    public void markTailCalls(CompileContext cc) {
        for (TypeswitchGroup tg : this.groups) {
            tg.markTailCalls(cc);
        }
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.cond.accept(visitor) && Typeswitch.visitAll(visitor, this.groups);
    }

    @Override
    public int exprSize() {
        int size = 1;
        for (TypeswitchGroup group : this.groups) {
            size += ((Expr)group).exprSize();
        }
        return size + this.cond.exprSize();
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Typeswitch(this.info, this.cond.copy(cc, vm), (TypeswitchGroup[])Arr.copyAll((CompileContext)cc, vm, (Expr[])this.groups)));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Typeswitch)) {
            return false;
        }
        Typeswitch ts = (Typeswitch)obj;
        return this.cond.equals(ts.cond) && Array.equals(this.groups, ts.groups);
    }

    @Override
    public void plan(FElem plan) {
        Typeswitch.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.groups, this.cond});
    }

    @Override
    public String toString() {
        return new TokenBuilder("typeswitch(" + this.cond + ")" + ' ').addSep(this.groups, " ").toString();
    }
}

