/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import java.util.ArrayList;
import org.basex.data.Data;
import org.basex.index.name.Names;
import org.basex.index.path.PathNode;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ItrPos;
import org.basex.query.expr.Preds;
import org.basex.query.expr.path.Axis;
import org.basex.query.expr.path.CachedStep;
import org.basex.query.expr.path.IterLastStep;
import org.basex.query.expr.path.IterPosStep;
import org.basex.query.expr.path.IterStep;
import org.basex.query.expr.path.KindTest;
import org.basex.query.expr.path.NameTest;
import org.basex.query.expr.path.Test;
import org.basex.query.func.Function;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public abstract class Step
extends Preds {
    public final Test test;
    public Axis axis;

    public static Step get(InputInfo info, Axis axis, Test test, Expr ... preds) {
        Step step = null;
        if (preds.length == 1 && preds[0].isFunction(Function.LAST)) {
            step = new IterLastStep(info, axis, test, preds);
        } else {
            boolean pos = false;
            for (Expr pred : preds) {
                if (pred instanceof ItrPos || Step.numeric(pred)) {
                    pos = true;
                    continue;
                }
                if (!pred.seqType().mayBeNumber() && !pred.has(Flag.POS)) continue;
                step = new CachedStep(info, axis, test, preds);
                break;
            }
            if (step == null) {
                step = pos ? new IterPosStep(info, axis, test, preds) : new IterStep(info, axis, test, preds);
            }
        }
        return step;
    }

    Step(InputInfo info, Axis axis, Test test, Expr ... exprs) {
        super(info, SeqType.get(test.type, Occ.ZERO_MORE), exprs);
        this.axis = axis;
        this.test = test;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        cc.pushFocus(this);
        try {
            super.compile(cc);
        }
        finally {
            cc.removeFocus();
        }
        return this.optimize(cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        Value value = cc.qc.focus.value;
        if (value != null && !this.test.optimize(value)) {
            cc.info("remove unknown element/attribute %", this.test);
            return Empty.SEQ;
        }
        this.simplify(cc, this);
        cc.pushFocus(this);
        try {
            Expr expr = super.optimize(cc);
            if (expr != this) {
                Expr expr2 = expr;
                return expr2;
            }
        }
        finally {
            cc.removeFocus();
        }
        if (!this.exprType(this.seqType(), this.size())) {
            return cc.emptySeq(this);
        }
        return this.copyType(Step.get(this.info, this.axis, this.test, this.exprs));
    }

    @Override
    public Expr inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        return Step.inlineAll(this.exprs, var, ex, cc) ? this.optimize(cc) : null;
    }

    @Override
    public abstract Step copy(CompileContext var1, IntObjMap<Var> var2);

    public final boolean simple(Axis ax, boolean name) {
        return this.axis == ax && (name ? this.test.kind == Test.Kind.NAME : this.test == KindTest.NOD) && this.exprs.length == 0;
    }

    final ArrayList<PathNode> nodes(ArrayList<PathNode> nodes, Data dt) {
        if (this.exprs.length != 0 || dt.nspaces.globalUri() == null) {
            return null;
        }
        byte kind = -1;
        int name = 0;
        if (this.test.type != null) {
            kind = ANode.kind(this.test.type);
            if (kind == 5) {
                return null;
            }
            if (this.test.kind == Test.Kind.NAME) {
                Names names = kind == 3 ? dt.attrNames : dt.elemNames;
                name = names.id(((NameTest)this.test).local);
            } else if (this.test.kind != null && this.test.kind != Test.Kind.WILDCARD) {
                return null;
            }
        }
        if (this.axis != Axis.ATTR && this.axis != Axis.CHILD && this.axis != Axis.DESC && this.axis != Axis.DESCORSELF && this.axis != Axis.SELF) {
            return null;
        }
        ArrayList<PathNode> tmp = new ArrayList<PathNode>();
        for (PathNode pn : nodes) {
            if (!(this.axis != Axis.SELF && this.axis != Axis.DESCORSELF || kind != -1 && (kind != pn.kind || name != 0 && name != pn.name) || tmp.contains(pn))) {
                tmp.add(pn);
            }
            if (this.axis == Axis.SELF) continue;
            this.add(pn, tmp, name, kind);
        }
        return tmp;
    }

    private void add(PathNode node, ArrayList<PathNode> nodes, int name, int kind) {
        for (PathNode n : node.children) {
            if (this.axis == Axis.DESC || this.axis == Axis.DESCORSELF) {
                this.add(n, nodes, name, kind);
            }
            if ((kind != -1 || !(n.kind != 3 ^ this.axis == Axis.ATTR)) && (kind != n.kind || name != 0 && name != n.name) || nodes.contains(n)) continue;
            nodes.add(n);
        }
    }

    final Step addPreds(Expr ... add) {
        return this.copyType(Step.get(this.info, this.axis, this.test, ExprList.concat(this.exprs, add)));
    }

    final ANode checkNode(QueryContext qc) throws QueryException {
        Value value = qc.focus.value;
        if (value instanceof ANode) {
            return (ANode)value;
        }
        throw value == null ? QueryError.NOCTX_X.get(this.info, this) : QueryError.STEPNODE_X_X_X.get(this.info, this, value.type, value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Step)) {
            return false;
        }
        Step s = (Step)obj;
        return this.axis == s.axis && this.test.equals(s.test) && super.equals(obj);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        for (Expr pred : this.exprs) {
            visitor.enterFocus();
            if (!pred.accept(visitor)) {
                return false;
            }
            visitor.exitFocus();
        }
        return true;
    }

    @Override
    public int exprSize() {
        int size = 1;
        for (Expr pred : this.exprs) {
            size += pred.exprSize();
        }
        return size;
    }

    @Override
    public final void plan(FElem plan) {
        Step.addPlan(plan, this.planElem("axis", this.axis.name, "test", this.test), this.exprs);
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.test == KindTest.NOD) {
            if (this.axis == Axis.PARENT) {
                sb.append("..");
            }
            if (this.axis == Axis.SELF) {
                sb.append('.');
            }
        }
        if (sb.length() == 0) {
            if (this.axis == Axis.ATTR && this.test instanceof NameTest) {
                sb.append('@');
            } else if (this.axis != Axis.CHILD) {
                sb.append((Object)this.axis).append("::");
            }
            sb.append(this.test);
        }
        return sb.append(super.toString()).toString();
    }
}

