/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.map;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncOptions;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.Map;
import org.basex.query.value.map.MergeDuplicates;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.options.EnumOption;
import org.basex.util.options.Options;

public final class MapMerge
extends StandardFunc {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item;
        Iter maps = this.exprs[0].iter(qc);
        MergeDuplicates merge = this.options(qc).get(MergeOptions.DUPLICATES);
        Map map = Map.EMPTY;
        while ((item = qc.next(maps)) != null) {
            map = map.addAll(this.toMap(item), merge, this.info, qc);
        }
        return map;
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Type type = this.exprs[0].seqType().type;
        if (type instanceof MapType) {
            MapType mt = (MapType)type;
            if (this.options(cc.qc).get(MergeOptions.DUPLICATES) == MergeDuplicates.COMBINE) {
                SeqType st = mt.declType;
                mt = MapType.get(mt.keyType(), st.with(st.mayBeEmpty() ? Occ.ZERO_MORE : Occ.ONE_MORE));
            }
            this.exprType.assign(mt);
        }
        return this;
    }

    private MergeOptions options(QueryContext qc) throws QueryException {
        MergeOptions opts = new MergeOptions();
        if (this.exprs.length > 1) {
            new FuncOptions(this.info).acceptUnknown().assign(this.toMap(this.exprs[1], qc), opts);
        }
        return opts;
    }

    public static final class MergeOptions
    extends Options {
        public static final EnumOption<MergeDuplicates> DUPLICATES = new EnumOption<MergeDuplicates>("duplicates", MergeDuplicates.USE_FIRST);
    }
}

