/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.list;

import java.util.Iterator;

public final class ElementNodes<E>
implements Iterable<E> {
    private Node<E> first;
    private Node<E> last;

    public void add(E entry) {
        Node node = new Node();
        node.entry = entry;
        if (this.first == null) {
            this.first = node;
        } else {
            this.last.next = node;
        }
        node.prev = this.last;
        this.last = node;
    }

    public NodeIterator iterator() {
        return new NodeIterator(this.first);
    }

    private Node<E> delete(Node<E> node) {
        Node n = node.next;
        Node p = node.prev;
        if (p != null) {
            p.next = n;
        } else {
            this.first = node;
        }
        if (n != null) {
            n.prev = p;
        } else {
            this.last = node;
        }
        return n;
    }

    public class NodeIterator
    implements Iterator<E> {
        private Node<E> init;
        private Node<E> curr;

        NodeIterator(Node<E> node) {
            this.init = node;
        }

        @Override
        public boolean hasNext() {
            if (this.curr == null) {
                this.curr = this.init;
                this.init = null;
            } else {
                this.curr = this.curr.next;
            }
            return this.curr != null;
        }

        @Override
        public E next() {
            return this.curr.entry;
        }

        @Override
        public void remove() {
            this.curr = ElementNodes.this.delete(this.curr);
        }

        public NodeIterator copy() {
            return new NodeIterator(this.curr);
        }
    }

    static class Node<E> {
        E entry;
        Node<E> next;
        Node<E> prev;

        Node() {
        }
    }
}

