/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.util.Arrays;
import org.basex.data.Data;
import org.basex.query.util.ft.FTPosData;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FTPosNode;
import org.basex.query.value.seq.DBNodeSeq;
import org.basex.query.value.type.NodeType;
import org.basex.util.list.IntList;

public final class DBNodes
extends DBNodeSeq {
    private FTPosData ftpos;
    private int[] sorted;

    public DBNodes(Data data, int ... pres) {
        this(data, false, pres);
    }

    public DBNodes(Data data, boolean all, int ... pres) {
        super(pres, data, all ? NodeType.DOC : NodeType.NOD, all);
    }

    public DBNodes ftpos(FTPosData ft) {
        this.ftpos = ft;
        return this;
    }

    public FTPosData ftpos() {
        return this.ftpos;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DBNodes)) {
            return false;
        }
        DBNodes n = (DBNodes)obj;
        return this.data == n.data && Arrays.equals(this.pres, n.pres) && (this.ftpos == null ? n.ftpos == null : this.ftpos.equals(n.ftpos));
    }

    public DBNodes discardDocs() {
        if (this.all) {
            return null;
        }
        int[] ps = this.pres;
        int pl = ps.length;
        IntList docs = this.data.resources.docs();
        if (pl != docs.size()) {
            return this;
        }
        int c = -1;
        while (++c < pl && ps[c] == docs.get(c)) {
        }
        return c < pl ? this : null;
    }

    public boolean contains(int pre) {
        return this.find(pre) >= 0;
    }

    public int find(int pre) {
        this.sort();
        return Arrays.binarySearch(this.sorted, pre);
    }

    public void toggle(int pre) {
        int[] n = new int[]{pre};
        this.pres = this.contains(pre) ? DBNodes.except(this.pres, n) : DBNodes.union(this.pres, n);
        this.size = this.pres.length;
        this.sorted = null;
    }

    public void union(int[] pre) {
        this.pres = DBNodes.union(this.pres, pre);
        this.size = this.pres.length;
        this.sorted = null;
    }

    private static int[] union(int[] pres1, int[] pres2) {
        int al = pres1.length;
        int bl = pres2.length;
        IntList il = new IntList();
        int a = 0;
        int b = 0;
        while (a != al && b != bl) {
            int d = pres1[a] - pres2[b];
            il.add(d <= 0 ? pres1[a++] : pres2[b++]);
            if (d != 0) continue;
            ++b;
        }
        while (a != al) {
            il.add(pres1[a++]);
        }
        while (b != bl) {
            il.add(pres2[b++]);
        }
        return il.finish();
    }

    private static int[] except(int[] pres1, int[] pres2) {
        int al = pres1.length;
        int bl = pres2.length;
        IntList il = new IntList();
        int a = 0;
        int b = 0;
        while (a != al && b != bl) {
            int d = pres1[a] - pres2[b];
            if (d < 0) {
                il.add(pres1[a]);
            } else {
                ++b;
            }
            if (d > 0) continue;
            ++a;
        }
        while (a != al) {
            il.add(pres1[a++]);
        }
        return il.finish();
    }

    private void sort() {
        if (this.sorted != null) {
            return;
        }
        int min = Integer.MIN_VALUE;
        for (int pre : this.pres) {
            if (pre < min) {
                this.sorted = Arrays.copyOf(this.pres, this.pres.length);
                Arrays.sort(this.sorted);
                return;
            }
            min = pre;
        }
        this.sorted = this.pres;
    }

    public int sorted(int index) {
        return this.sorted[index];
    }

    @Override
    public DBNode itemAt(long pos) {
        int pre = this.pres[(int)pos];
        return this.ftpos == null ? new DBNode(this.data, pre) : new FTPosNode(this.data, pre, this.ftpos);
    }
}

