/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.util;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class CmdLine {
    String appName;
    Option[] options = new Option[1];
    String[] args;
    int argp;
    int anonymous;
    int HELP_TAB = 22;
    static final char ARG_SET = '.';
    static final char ARG_RESET = '-';
    static final char ARG_NEXT = '_';
    static final char ARG_STUCK = ':';
    static final char ARG_ALL = '*';
    static final char ARG_SELF = '@';
    static final char ACT_SET = '=';
    static final char ACT_CALL = '!';
    static final char ACT_HELP = '?';

    public CmdLine(String string) {
        this.appName = string;
    }

    public void define(String string, String string2, String string3, String string4) {
        char c = '@';
        if (string != null) {
            c = string.charAt(string.length() - 1);
            string = string.substring(0, string.length() - 1);
        }
        Option option = new Option(string, c, string2, string3.charAt(0), string3.substring(1), string4);
        if (string == null) {
            this.options[0] = option;
        } else {
            Option[] optionArray = this.options;
            this.options = new Option[optionArray.length + 1];
            System.arraycopy(optionArray, 0, this.options, 0, optionArray.length);
            this.options[optionArray.length] = option;
        }
    }

    public void parse(String[] stringArray, Object object) throws Exception {
        this.args = stringArray;
        this.argp = 0;
        try {
            Object object2;
            String[] stringArray2;
            while (this.argp < stringArray.length) {
                stringArray2 = stringArray[this.argp++];
                object2 = this.matchOption((String)stringArray2);
                String[] stringArray3 = null;
                switch (((Option)object2).syntax) {
                    case '@': {
                        stringArray3 = stringArray2;
                        break;
                    }
                    case '.': {
                        stringArray3 = Boolean.TRUE;
                        break;
                    }
                    case '-': {
                        stringArray3 = Boolean.FALSE;
                        break;
                    }
                    case '_': {
                        if (this.argp >= stringArray.length) {
                            throw new Error("option " + ((Option)object2).key + " requires an argument");
                        }
                        stringArray3 = stringArray[this.argp++];
                        break;
                    }
                    case ':': {
                        stringArray3 = stringArray2.substring(((Option)object2).key.length());
                        break;
                    }
                    case '*': {
                        String[] stringArray4 = new String[stringArray.length - this.argp];
                        System.arraycopy(stringArray, this.argp, stringArray4, 0, stringArray4.length);
                        stringArray3 = stringArray4;
                        this.argp = stringArray.length;
                        break;
                    }
                    default: {
                        throw new RuntimeException("illegal option syntax: " + ((Option)object2).syntax);
                    }
                }
                switch (((Option)object2).action) {
                    case '=': {
                        this.setField(object, ((Option)object2).key, ((Option)object2).actName, stringArray3);
                        break;
                    }
                    case '!': {
                        this.callMethod(object, ((Option)object2).key, ((Option)object2).actName, stringArray3);
                        break;
                    }
                    case '?': {
                        throw new Error("help:");
                    }
                    default: {
                        throw new RuntimeException("illegal option action: " + ((Option)object2).action);
                    }
                }
            }
            try {
                stringArray2 = object.getClass().getDeclaredMethod("finish", new Class[0]);
                stringArray2.invoke(object, null);
            }
            catch (InvocationTargetException invocationTargetException) {
                object2 = invocationTargetException.getCause();
                if (object2 instanceof java.lang.Error) {
                    throw (java.lang.Error)object2;
                }
                throw (Exception)invocationTargetException.getCause();
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        catch (Error error) {
            System.err.println("*** " + error.getMessage());
            this.printHelp(System.err);
            throw error;
        }
    }

    private Option matchOption(String string) {
        int n = this.options.length;
        while (--n > 0) {
            if (!this.options[n].key.equals(string) && (this.options[n].syntax != ':' || !string.startsWith(this.options[n].key))) continue;
            return this.options[n];
        }
        return this.options[0];
    }

    public void printHelp(PrintStream printStream) {
        printStream.print("usage: " + this.appName + " [options]");
        if (this.options[0] != null) {
            printStream.print(this.options[0].help);
        }
        printStream.println();
        printStream.println(" options:");
        int n = 1;
        while (n < this.options.length) {
            Option option = this.options[n];
            String string = option.help;
            if (string != null) {
                int n2 = option.key.length();
                printStream.print("  " + option.key);
                if (option.syntax != ':') {
                    printStream.print(' ');
                    ++n2;
                }
                n2 += option.argLabel.length();
                printStream.print(option.argLabel);
                while (n2 < this.HELP_TAB) {
                    printStream.print(' ');
                    ++n2;
                }
                String[] stringArray = string.split("\n");
                printStream.println(" " + stringArray[0]);
                int n3 = 1;
                while (n3 < stringArray.length) {
                    n2 = -2;
                    while (n2 < this.HELP_TAB) {
                        printStream.print(' ');
                        ++n2;
                    }
                    printStream.println(" " + stringArray[n3]);
                    ++n3;
                }
            }
            ++n;
        }
    }

    void callMethod(Object object, String string, String string2, Object object2) throws Exception {
        try {
            Method method = object.getClass().getDeclaredMethod(string2, object2.getClass());
            method.invoke(object, object2);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof java.lang.Error) {
                throw (java.lang.Error)throwable;
            }
            throw (Exception)throwable;
        }
        catch (Exception exception) {
            System.err.println("Error in option " + string + ":" + exception);
            throw exception;
        }
    }

    void setField(Object object, String string, String string2, Object object2) throws Exception {
        try {
            Field field = object.getClass().getField(string2);
            Class<?> clazz = field.getType();
            if (clazz == Integer.TYPE) {
                field.setInt(object, Integer.parseInt((String)object2));
            } else if (clazz == Float.TYPE) {
                field.setFloat(object, Float.parseFloat((String)object2));
            } else if (clazz == Double.TYPE) {
                field.setDouble(object, Double.parseDouble((String)object2));
            } else if (clazz == Boolean.TYPE) {
                if (object2 instanceof String) {
                    field.setBoolean(object, object2.equals("1") || ((String)object2).equalsIgnoreCase("yes") || ((String)object2).equalsIgnoreCase("true"));
                } else {
                    field.set(object, object2);
                }
            } else if (clazz.isArray()) {
                String[] stringArray = (String[])field.get(object);
                String[] stringArray2 = null;
                if (object2 instanceof String) {
                    stringArray2 = new String[stringArray.length + 1];
                    System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                    stringArray2[stringArray.length] = (String)object2;
                } else {
                    String[] stringArray3 = (String[])object2;
                    stringArray2 = new String[stringArray.length + stringArray3.length];
                    System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                    System.arraycopy(stringArray3, 0, stringArray2, stringArray.length, stringArray3.length);
                }
                field.set(object, stringArray2);
            } else {
                field.set(object, object2);
            }
        }
        catch (Exception exception) {
            System.err.println("Error in option " + string + ": " + exception);
            throw exception;
        }
    }

    public static class Error
    extends Exception {
        public Error() {
        }

        public Error(String string) {
            super(string);
        }
    }

    protected static class Option {
        String key;
        String argLabel;
        String actName;
        String help;
        char syntax;
        char action;

        Option(String string, char c, String string2, char c2, String string3, String string4) {
            this.key = string;
            this.syntax = c;
            this.argLabel = string2;
            this.action = c2;
            this.actName = string3;
            this.help = string4;
        }
    }
}

