/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.util;

import java.io.Serializable;
import net.xfra.qizxopen.util.WordSifter;

public class DefaultWordSifter
implements WordSifter,
Serializable {
    char[] text;
    int length;
    int ptr;
    int wordStart;
    char[] mapping;
    byte[] charType;
    char wildcardStar = (char)37;
    char wildcardOne = (char)95;

    public DefaultWordSifter() {
        this.setup(false, false);
    }

    public DefaultWordSifter(boolean bl, boolean bl2) {
        this.setup(bl, bl2);
    }

    public void start(char[] cArray, int n) {
        this.text = cArray;
        this.length = n;
        this.ptr = 0;
    }

    public boolean isWordStart(char c) {
        return c >= '\u00c0' ? true : this.charType[c] > 1;
    }

    public boolean isWordPart(char c) {
        return c >= '\u00c0' ? true : this.charType[c] > 0;
    }

    public char wildcardSeveral() {
        return this.wildcardStar;
    }

    public char wildcardSingle() {
        return this.wildcardOne;
    }

    public char mapChar(char c) {
        return c >= this.mapping.length ? c : this.mapping[c];
    }

    public char[] nextWord() {
        while (this.ptr < this.length) {
            char c = this.text[this.ptr];
            if (this.isWordStart(c)) {
                this.wordStart = this.ptr;
                int n = this.ptr + 1;
                while (n < this.length) {
                    char c2 = this.text[n];
                    if (!this.isWordPart(c2) && (c2 != '.' || n >= this.length - 1 || Character.isWhitespace(this.text[n + 1]))) break;
                    ++n;
                }
                this.ptr = n;
                if (n - this.wordStart > 1) {
                    char[] cArray = new char[n - this.wordStart];
                    int n2 = cArray.length;
                    while (--n2 >= 0) {
                        cArray[n2] = this.mapChar(this.text[this.wordStart + n2]);
                    }
                    return cArray;
                }
            }
            ++this.ptr;
        }
        return null;
    }

    public char charAt(int n) {
        return this.ptr + n >= this.length ? (char)'\u0000' : this.text[this.ptr + n];
    }

    public char nextChar() {
        if (this.ptr >= this.length) {
            return '\u0000';
        }
        ++this.ptr;
        return this.charAt(0);
    }

    public int wordOffset() {
        return this.wordStart;
    }

    public int wordLength() {
        return this.ptr - this.wordStart;
    }

    private final void mapRange(int n, int n2, char c) {
        while (n <= n2) {
            this.mapping[n] = c;
            ++n;
        }
    }

    void setup(boolean bl, boolean bl2) {
        this.charType = new byte[192];
        int n = 48;
        while (n <= 57) {
            this.charType[n] = 2;
            ++n;
        }
        int n2 = 65;
        while (n2 <= 90) {
            this.charType[n2 + 32] = 2;
            this.charType[n2] = 2;
            ++n2;
        }
        this.charType[95] = 2;
        this.charType[45] = 1;
        this.mapping = new char[768];
        char c = '\u0000';
        while (c < (char)this.mapping.length) {
            this.mapping[c] = bl ? c : Character.toLowerCase(c);
            c = (char)(c + '\u0001');
        }
        if (bl2) {
            return;
        }
        this.mapRange(192, 197, this.mapChar('A'));
        this.mapping[198] = 230;
        this.mapping[199] = this.mapChar('C');
        this.mapRange(200, 203, this.mapChar('E'));
        this.mapRange(204, 207, this.mapChar('I'));
        this.mapping[209] = this.mapChar('N');
        this.mapRange(210, 216, this.mapChar('O'));
        this.mapRange(217, 220, this.mapChar('U'));
        this.mapping[221] = this.mapChar('Y');
        this.mapRange(224, 229, 'a');
        this.mapping[231] = 99;
        this.mapRange(232, 235, 'e');
        this.mapRange(236, 239, 'i');
        this.mapping[240] = 208;
        this.mapping[241] = 110;
        this.mapRange(242, 248, 'o');
        this.mapRange(249, 252, 'u');
        this.mapping[253] = 121;
        this.mapping[254] = 222;
        this.mapping[255] = 121;
        this.mapRange(256, 261, 'a');
        this.mapRange(262, 269, 'c');
        this.mapRange(270, 273, 'd');
        this.mapRange(274, 283, 'e');
        this.mapRange(284, 291, 'g');
        this.mapRange(292, 295, 'h');
        this.mapRange(296, 305, 'i');
        this.mapping[307] = 306;
        this.mapRange(308, 309, 'j');
        this.mapRange(310, 311, 'k');
        this.mapRange(313, 322, 'l');
        this.mapRange(323, 329, 'n');
        this.mapRange(332, 337, 'o');
        this.mapRange(340, 345, 'r');
        this.mapRange(346, 353, 's');
        this.mapRange(354, 359, 't');
        this.mapRange(360, 371, 'u');
        this.mapRange(372, 373, 'w');
        this.mapRange(374, 376, 'y');
        this.mapRange(377, 382, 'z');
        this.mapping[383] = 115;
        this.mapRange(384, 387, 'b');
        this.mapping[390] = 111;
        this.mapRange(391, 392, 'c');
        this.mapRange(393, 396, 'd');
        this.mapping[398] = this.mapChar('E');
        this.mapping[400] = this.mapChar('E');
        this.mapping[401] = this.mapChar('F');
        this.mapping[402] = 102;
        this.mapping[403] = this.mapChar('G');
        this.mapping[407] = this.mapChar('I');
        this.mapping[408] = this.mapChar('K');
        this.mapping[409] = 107;
        this.mapping[410] = 108;
        this.mapping[412] = this.mapChar('M');
        this.mapping[413] = this.mapChar('N');
        this.mapping[414] = 110;
        this.mapping[415] = this.mapChar('O');
        this.mapping[416] = this.mapChar('O');
        this.mapping[417] = 111;
        this.mapping[419] = 418;
        this.mapping[420] = this.mapChar('P');
        this.mapping[421] = 112;
        this.mapping[427] = 116;
        this.mapping[428] = this.mapChar('T');
        this.mapping[429] = 116;
        this.mapping[430] = this.mapChar('T');
        this.mapping[431] = this.mapChar('U');
        this.mapping[432] = 117;
        this.mapping[434] = this.mapChar('V');
        this.mapping[435] = this.mapChar('Y');
        this.mapping[436] = 121;
        this.mapping[437] = this.mapChar('Z');
        this.mapping[438] = 122;
        this.mapping[440] = this.mapChar('\u01b7');
        this.mapping[441] = 439;
        this.mapping[442] = 439;
        this.mapping[461] = this.mapChar('A');
        this.mapping[462] = 97;
        this.mapping[463] = this.mapChar('I');
        this.mapping[464] = 105;
        this.mapping[465] = this.mapChar('O');
        this.mapping[466] = 111;
        this.mapRange(467, 476, 'u');
        this.mapping[477] = 101;
        this.mapping[478] = this.mapChar('A');
        this.mapping[479] = 97;
        this.mapping[480] = this.mapChar('A');
        this.mapping[481] = 97;
        this.mapping[482] = this.mapChar('\u00c6');
        this.mapping[483] = 198;
        this.mapping[484] = this.mapChar('G');
        this.mapping[485] = 103;
        this.mapping[486] = this.mapChar('G');
        this.mapping[487] = 103;
        this.mapping[488] = this.mapChar('K');
        this.mapping[489] = 107;
        this.mapping[490] = this.mapChar('O');
        this.mapping[491] = 111;
        this.mapping[492] = this.mapChar('O');
        this.mapping[493] = 111;
        this.mapping[494] = this.mapChar('\u01b7');
        this.mapping[495] = 439;
        this.mapping[496] = 106;
        this.mapping[499] = 497;
        this.mapping[500] = this.mapChar('G');
        this.mapping[501] = 103;
        this.mapping[506] = this.mapChar('A');
        this.mapping[507] = 97;
        this.mapping[508] = this.mapChar('\u00c6');
        this.mapping[509] = 198;
        this.mapping[510] = this.mapChar('O');
        this.mapping[511] = 111;
        this.mapping[512] = this.mapChar('A');
        this.mapping[513] = 97;
        this.mapping[514] = this.mapChar('A');
        this.mapping[515] = 97;
        this.mapping[516] = this.mapChar('E');
        this.mapping[517] = 101;
        this.mapping[518] = this.mapChar('E');
        this.mapping[519] = 101;
        this.mapping[520] = this.mapChar('I');
        this.mapping[521] = 105;
        this.mapping[522] = this.mapChar('I');
        this.mapping[523] = 105;
        this.mapping[524] = this.mapChar('O');
        this.mapping[525] = 111;
        this.mapping[526] = this.mapChar('O');
        this.mapping[527] = 111;
        this.mapping[528] = this.mapChar('R');
        this.mapping[529] = 114;
        this.mapping[530] = this.mapChar('R');
        this.mapping[531] = 114;
        this.mapping[532] = this.mapChar('U');
        this.mapping[533] = 117;
        this.mapping[534] = this.mapChar('U');
        this.mapping[535] = 117;
        this.mapping[592] = 97;
        this.mapping[595] = 98;
        this.mapping[596] = 111;
        this.mapping[597] = 99;
        this.mapping[598] = 100;
        this.mapping[599] = 100;
        this.mapping[600] = 101;
        this.mapping[603] = 101;
        this.mapping[604] = 101;
        this.mapping[605] = 101;
        this.mapping[606] = 101;
        this.mapping[607] = 106;
        this.mapping[608] = 103;
        this.mapping[609] = 103;
        this.mapping[610] = this.mapChar('G');
        this.mapping[613] = 104;
        this.mapping[614] = 104;
        this.mapping[616] = 105;
        this.mapping[618] = this.mapChar('I');
        this.mapping[619] = 108;
        this.mapping[620] = 108;
        this.mapping[621] = 108;
        this.mapping[623] = 109;
        this.mapping[624] = 109;
        this.mapping[625] = 109;
        this.mapping[626] = 110;
        this.mapping[627] = 110;
        this.mapping[628] = this.mapChar('N');
        this.mapping[629] = 111;
        this.mapping[630] = this.mapChar('\u0152');
        this.mapping[633] = 114;
        this.mapping[634] = 114;
        this.mapping[635] = 114;
        this.mapping[636] = 114;
        this.mapping[637] = 114;
        this.mapping[638] = 114;
        this.mapping[639] = 114;
        this.mapping[640] = this.mapChar('R');
        this.mapping[641] = this.mapChar('R');
        this.mapping[642] = 115;
        this.mapping[644] = 106;
        this.mapping[647] = 116;
        this.mapping[648] = 116;
        this.mapping[649] = 117;
        this.mapping[651] = 118;
        this.mapping[652] = 118;
        this.mapping[653] = 119;
        this.mapping[654] = 122;
        this.mapping[655] = this.mapChar('Y');
        this.mapping[656] = 122;
        this.mapping[657] = 122;
        this.mapping[658] = 439;
        this.mapping[659] = 439;
        this.mapping[663] = 99;
        this.mapping[665] = this.mapChar('B');
        this.mapping[666] = 101;
        this.mapping[667] = this.mapChar('G');
        this.mapping[668] = this.mapChar('H');
    }
}

