/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.util;

import net.xfra.qizxopen.util.Namespace;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.util.XMLUtil;

public class NSPrefixMapping {
    private int ptr = 0;
    private String[] prefixes;
    private Namespace[] namespaces;
    public static final NSPrefixMapping std = new NSPrefixMapping();

    public NSPrefixMapping copy() {
        NSPrefixMapping nSPrefixMapping = new NSPrefixMapping();
        nSPrefixMapping.ptr = this.ptr;
        nSPrefixMapping.prefixes = (String[])this.prefixes.clone();
        nSPrefixMapping.namespaces = (Namespace[])this.namespaces.clone();
        return nSPrefixMapping;
    }

    public void addMapping(String string, String string2) {
        this.addMapping(string, Namespace.get(string2));
    }

    public void addMapping(String string, Namespace namespace) {
        if (this.prefixes == null) {
            this.prefixes = new String[4];
            this.namespaces = new Namespace[4];
        } else if (this.ptr >= this.prefixes.length) {
            String[] stringArray = this.prefixes;
            this.prefixes = new String[2 * stringArray.length];
            System.arraycopy(stringArray, 0, this.prefixes, 0, stringArray.length);
            Namespace[] namespaceArray = this.namespaces;
            this.namespaces = new Namespace[2 * namespaceArray.length];
            System.arraycopy(namespaceArray, 0, this.namespaces, 0, namespaceArray.length);
        }
        this.prefixes[this.ptr] = string;
        this.namespaces[this.ptr] = namespace;
        ++this.ptr;
    }

    public int getMappingCount() {
        return this.ptr;
    }

    public void removeMappings(int n) {
        this.ptr -= n;
    }

    public Namespace convertToNamespace(String string) {
        int n = this.ptr;
        while (--n >= 0) {
            if (!this.prefixes[n].equals(string)) continue;
            return this.namespaces[n];
        }
        return null;
    }

    public String convertToPrefix(Namespace namespace) {
        int n = this.ptr;
        while (--n >= 0) {
            if (this.namespaces[n] != namespace) continue;
            return this.prefixes[n];
        }
        return null;
    }

    public static String extractPrefix(String string) {
        String string2;
        int n = string.indexOf(58);
        String string3 = string2 = n < 0 ? "" : string.substring(0, n);
        if (string2.length() > 0 && !XMLUtil.isNCName(string2)) {
            throw new IllegalArgumentException("illegal prefix " + string2);
        }
        return string2;
    }

    public static String extractLocalName(String string) {
        int n = string.indexOf(58);
        String string2 = string.substring(n + 1);
        if (!XMLUtil.isNCName(string2)) {
            throw new IllegalArgumentException("illegal local name " + string2);
        }
        return string2;
    }

    public QName expandName(String string) {
        String string2 = NSPrefixMapping.extractPrefix(string);
        Namespace namespace = string2.length() == 0 ? Namespace.NONE : this.convertToNamespace(string2);
        return namespace == null ? null : QName.get(namespace, NSPrefixMapping.extractLocalName(string));
    }

    public String prefixedName(QName qName) {
        if (qName.getNamespace() == Namespace.NONE) {
            return qName.getLocalName();
        }
        return this.convertToPrefix(qName.getNamespace()) + ":" + qName.getLocalName();
    }

    public String getLastPrefix(int n) {
        return this.prefixes[this.ptr - n];
    }

    public Namespace getLastNamespace(int n) {
        return this.namespaces[this.ptr - n];
    }

    static {
        std.addMapping("xml", Namespace.XML);
        std.addMapping("xs", Namespace.XSD);
        std.addMapping("xsi", Namespace.XSI);
        std.addMapping("fn", Namespace.FN);
        std.addMapping("op", Namespace.OP);
    }
}

