/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.util;

import java.util.HashMap;
import net.xfra.qizxopen.util.Namespace;

public final class QName {
    private static HashMap names = new HashMap();
    private static QName probe = new QName(null, null);
    public static final QName XML_LANG = QName.get(Namespace.XML, "lang");
    public static final QName XML_SPACE = QName.get(Namespace.XML, "space");
    public static final QName XML_BASE = QName.get(Namespace.XML, "base");
    public static final QName XSI_TYPE = QName.get(Namespace.XSI, "type");
    public static final QName XSI_NIL = QName.get(Namespace.XSI, "nil");
    public static final QName XSI_SCHEMA_LOCATION = QName.get(Namespace.XSI, "schemaLocation");
    public static final QName XSI_NO_NAMESPACE_SCHEMA_LOCATION = QName.get(Namespace.XSI, "noNamespaceSchemaLocation");
    private Namespace namespace;
    private String localName;

    public static synchronized QName get(String string, String string2) {
        return QName.get(Namespace.get(string), string2);
    }

    public static synchronized QName get(Namespace namespace, String string) {
        if (namespace == null) {
            throw new IllegalArgumentException("null namespace");
        }
        if (string == null) {
            throw new IllegalArgumentException("null localName");
        }
        QName.probe.namespace = namespace;
        QName.probe.localName = string;
        QName qName = (QName)names.get(probe);
        if (qName == null) {
            qName = new QName(namespace, string);
            names.put(qName, qName);
        }
        return qName;
    }

    public static synchronized QName get(String string) {
        return QName.get(Namespace.NONE, string);
    }

    public boolean equals(Object object) {
        if (object instanceof QName) {
            QName qName = (QName)object;
            return this.namespace == qName.namespace && this.localName.equals(qName.localName);
        }
        if (object instanceof String) {
            return this.namespace == Namespace.NONE && this.localName.equals((String)object);
        }
        return false;
    }

    public int hashCode() {
        return System.identityHashCode(this.namespace) ^ this.localName.hashCode();
    }

    private QName(Namespace namespace, String string) {
        this.namespace = namespace;
        this.localName = string == null ? null : string.intern();
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String getURI() {
        return this.namespace.getURI();
    }

    public String getLocalName() {
        return this.localName;
    }

    public String toString() {
        if (this.namespace == Namespace.NONE) {
            return this.localName;
        }
        return '{' + this.namespace.getURI() + '}' + this.localName;
    }

    public int compareTo(QName qName) {
        if (this.namespace == qName.namespace) {
            return this.localName.compareTo(qName.localName);
        }
        return this.namespace.compareTo(qName.namespace);
    }
}

