/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.util;

public class Timer
extends Thread {
    Request requests_;
    static Timer StaticTimer = null;

    public Timer() {
        this.setDaemon(true);
    }

    public synchronized Request newRequest(int n, Handler handler) {
        Request request = new Request();
        request.expiration = System.currentTimeMillis() + (long)n;
        request.handler = handler;
        if (this.requests_ == null) {
            this.requests_ = request;
        } else {
            Request request2 = this.requests_;
            Request request3 = null;
            while (request2 != null) {
                if (request2.expiration > request.expiration) {
                    request.next = request2;
                    if (request3 == null) {
                        this.requests_ = request;
                        break;
                    }
                    request3.next = request;
                    break;
                }
                request3 = request2;
                request2 = request2.next;
            }
            if (request2 == null) {
                request3.next = request;
            }
        }
        this.notify();
        return request;
    }

    public static synchronized Request request(int n, Handler handler) {
        if (StaticTimer == null) {
            StaticTimer = new Timer();
            StaticTimer.start();
        }
        return StaticTimer.newRequest(n, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Timer timer = this;
            synchronized (timer) {
                long l = 1000L;
                if (this.requests_ != null) {
                    long l2 = System.currentTimeMillis();
                    if (l2 >= this.requests_.expiration) {
                        Request request = this.requests_;
                        this.requests_ = request.next;
                        if (!request.cancelled) {
                            request.handler.timeEvent(request);
                        }
                        continue;
                    }
                    l = this.requests_.expiration - l2;
                }
                try {
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static class Request {
        long expiration;
        boolean cancelled;
        Request next;
        Handler handler;

        public void cancel() {
            this.cancelled = true;
        }
    }

    public static interface Handler {
        public void timeEvent(Request var1);
    }
}

