/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class Util {
    static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static String RESERVED = ";/?:@&=+$,#[]";
    public static String MARKS = "-_.!~*'()";
    public static String HEX = "0123456789ABCDEFabcdef";
    static Charset UTF8;

    public static void printf(char[] cArray) {
        Util.fprintf(System.out, cArray);
    }

    public static void fprintf(PrintStream printStream, char[] cArray) {
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] < ' ') {
                printStream.print("&" + cArray[n] + ";");
            } else {
                printStream.print(cArray[n]);
            }
            ++n;
        }
    }

    public static String toHex(int n, int n2) {
        char[] cArray = new char[8];
        int n3 = 7;
        do {
            cArray[n3--] = hexDigits[n & 0xF];
        } while ((n >>= 4) != 0 || --n2 > 0);
        return new String(cArray, n3 + 1, 7 - n3);
    }

    public static int setBit(int n, int n2) {
        return n | 1 << n2;
    }

    public static int clearBit(int n, int n2) {
        return n & ~(1 << n2);
    }

    public static boolean testBit(int n, int n2) {
        return (n & 1 << n2) != 0;
    }

    public static int comparison(int n) {
        return n < 0 ? -1 : (n > 0 ? 1 : 0);
    }

    public static int comparison(double d) {
        return d < 0.0 ? -1 : (d > 0.0 ? 1 : 0);
    }

    public static String camelCase(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.append(bl ? Character.toUpperCase(string.charAt(0)) : string.charAt(0));
        int n = 1;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (c != '-') {
                stringBuffer.append(c);
            } else if (++n < n2) {
                stringBuffer.append(Character.toUpperCase(string.charAt(n)));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static URL uriToURL(String string) throws IOException {
        if (string == null) {
            string = ".";
        }
        if (!string.endsWith("/")) {
            string = string.concat("/");
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = new File(string).getCanonicalFile().toURL();
        }
        return uRL;
    }

    public static String normalizePath(String string, boolean bl) {
        char c;
        int n = string.length();
        int n2 = 1;
        boolean bl2 = false;
        char[] cArray = new char[n + 1];
        cArray[0] = 47;
        int n3 = 0;
        while (n3 < n) {
            c = string.charAt(n3);
            if (c == '/') {
                if (cArray[n2 - 1] != '/') {
                    n2 = Util.processComponent(cArray, n2);
                    cArray[n2++] = 47;
                }
            } else {
                cArray[n2++] = c;
            }
            ++n3;
        }
        if ((n2 = Util.processComponent(cArray, n2)) > 2 && cArray[n2 - 1] == '/') {
            --n2;
        }
        if (n2 == 0) {
            return bl ? "/" : ".";
        }
        c = '\u0001';
        if (bl || string.charAt(0) == '/' || string.charAt(0) == '\\') {
            c = '\u0000';
        }
        return new String(cArray, (int)c, n2 - c);
    }

    private static int processComponent(char[] cArray, int n) {
        if (n < 2 || cArray[n - 1] != '.') {
            return n;
        }
        if (cArray[n - 2] == '/') {
            return n - 2;
        }
        if (n < 3 || cArray[n - 2] != '.' || cArray[n - 3] != '/') {
            return n;
        }
        n -= 3;
        while (n > 0 && cArray[n - 1] != '/') {
            --n;
        }
        return n;
    }

    static boolean isHexa(char c) {
        return HEX.indexOf(c) >= 0;
    }

    public static void escapeURI(String string, boolean bl, StringBuffer stringBuffer) {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || MARKS.indexOf(c) >= 0 || !bl || RESERVED.indexOf(c) < 0 || c == '%' && n < n2 - 2 && Util.isHexa(string.charAt(n + 1)) && Util.isHexa(string.charAt(n + 2))) {
                stringBuffer.append(c);
            } else {
                try {
                    ByteBuffer byteBuffer = UTF8.encode(string.substring(n, n + 1));
                    while (byteBuffer.hasRemaining()) {
                        byte by = byteBuffer.get();
                        stringBuffer.append('%');
                        stringBuffer.append(HEX.charAt(by >>> 4));
                        stringBuffer.append(HEX.charAt(by & 0xF));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ++n;
        }
    }

    static {
        try {
            UTF8 = Charset.forName("UTF-8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

