/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.util.time;

import net.xfra.qizxopen.util.time.DateTimeBase;
import net.xfra.qizxopen.util.time.DateTimeException;

public class DateTime
extends DateTimeBase {
    public DateTime(int n, int n2, int n3, int n4, int n5, double d, int n6, int n7, int n8) throws DateTimeException {
        super(n, n2, n3, n4, n5, d, n6, n7, n8);
    }

    public DateTime(DateTimeBase dateTimeBase) throws DateTimeException {
        this(dateTimeBase.year, dateTimeBase.month, dateTimeBase.day, dateTimeBase.hour, dateTimeBase.minute, dateTimeBase.second, dateTimeBase.tzSign, dateTimeBase.tzHour, dateTimeBase.tzMinute);
    }

    public DateTime() {
    }

    public DateTimeBase parse(String string, int n) throws DateTimeException {
        return DateTime.parseDateTime(string, n);
    }

    public static DateTime parseDateTime(String string, int n) throws DateTimeException {
        int n2;
        int[] nArray = new int[3];
        int n3 = string.length();
        if (n3 == 0) {
            throw new DateTimeException("invalid syntax", string);
        }
        int n4 = 0;
        boolean bl = false;
        if (string.charAt(n4) == '-') {
            bl = true;
            ++n4;
        }
        if ((n2 = string.indexOf(45, n4)) < n4 + 4) {
            throw new DateTimeException("invalid year", string);
        }
        int n5 = DateTimeBase.parseInt(string, n4, n2);
        if (bl) {
            n5 = -n5;
        }
        if ((n4 = n2 + 1) + 2 >= n3 || string.charAt(n4 + 2) != '-') {
            throw new DateTimeException("invalid month", string);
        }
        int n6 = DateTimeBase.parseInt(string, n4, n4 + 2);
        if ((n4 += 3) + 2 >= n3 || string.charAt(n4 + 2) != 'T') {
            throw new DateTimeException("invalid day", string);
        }
        int n7 = DateTimeBase.parseInt(string, n4, n4 + 2);
        if ((n4 += 3) + 2 >= n3 || string.charAt(n4 + 2) != ':') {
            throw new DateTimeException("invalid syntax", string);
        }
        int n8 = DateTimeBase.parseInt(string, n4, n4 + 2);
        if ((n4 += 3) + 2 >= n3 || string.charAt(n4 + 2) != ':') {
            throw new DateTimeException("invalid syntax", string);
        }
        int n9 = DateTimeBase.parseInt(string, n4, n4 + 2);
        n2 = DateTimeBase.parseTimeZone(string, n4 += 3, nArray);
        if (n2 < n4 + 2) {
            throw new DateTimeException("invalid syntax", string);
        }
        double d = DateTimeBase.parseDouble(string, n4, n2);
        DateTime dateTime = new DateTime(n5, n6, n7, n8, n9, d, nArray[0], nArray[1], nArray[2]);
        if (nArray[0] == 0) {
            dateTime.forceTimeZone(n);
        }
        return dateTime;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.year < 0) {
            stringBuffer.append('-');
            DateTimeBase.appendPadded(-this.year, 4, stringBuffer);
        } else {
            DateTimeBase.appendPadded(this.year, 4, stringBuffer);
        }
        stringBuffer.append('-');
        DateTimeBase.appendPadded(this.month, 2, stringBuffer);
        stringBuffer.append('-');
        DateTimeBase.appendPadded(this.day, 2, stringBuffer);
        stringBuffer.append('T');
        DateTimeBase.appendPadded(this.hour, 2, stringBuffer);
        stringBuffer.append(':');
        DateTimeBase.appendPadded(this.minute, 2, stringBuffer);
        stringBuffer.append(':');
        DateTimeBase.appendPadded(this.second, 2, stringBuffer);
        DateTimeBase.appendTimeZone(this.tzSign, this.tzHour, this.tzMinute, stringBuffer);
        return stringBuffer.toString();
    }
}

