/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery;

import java.io.IOException;
import net.xfra.qizxopen.dm.FONIDocument;
import net.xfra.qizxopen.dm.SAXEventReceiver;
import net.xfra.qizxopen.util.Util;
import net.xfra.qizxopen.xquery.XQuery;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.XQueryProcessor;
import net.xfra.qizxopen.xquery.dm.FONIDataModel;
import net.xfra.qizxopen.xquery.dt.SingleNode;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class SAXXQueryProcessor
extends XQueryProcessor
implements XMLReader {
    private XQuery query;
    private SAXEventReceiver saxout = new SAXEventReceiver();
    private DTDHandler dtdHandler;
    private EntityResolver entityResolver;
    static final String FEATURE_NS = "http://xml.org/sax/features/namespaces";
    static final String FEATURE_NSPREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    static final String PROPERTY_LEXICAL = "http://xml.org/sax/properties/lexical-handler";

    public SAXXQueryProcessor() {
    }

    public SAXXQueryProcessor(String string, String string2) throws IOException {
        super(string, string2);
    }

    public SAXXQueryProcessor(XQueryProcessor xQueryProcessor) {
        super(xQueryProcessor);
    }

    public void setQuery(XQuery xQuery) {
        this.query = xQuery;
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        if (this.docMan == null) {
            throw new IllegalArgumentException("no Document Manager specified");
        }
        if (this.query == null) {
            throw new IllegalArgumentException("no query specified");
        }
        this.execute(inputSource == null ? null : this.docMan.parseDocument(inputSource));
    }

    public void parse(String string) throws IOException, SAXException {
        if (this.docMan == null) {
            throw new IllegalArgumentException("no Document Manager specified");
        }
        if (this.query == null) {
            throw new IllegalArgumentException("no query specified");
        }
        this.execute(this.docMan.parseDocument(Util.uriToURL(string)));
    }

    public ContentHandler getContentHandler() {
        return this.saxout.getContentHandler();
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.saxout.setContentHandler(contentHandler);
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.saxout.getErrorHandler();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.saxout.setErrorHandler(errorHandler);
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals(FEATURE_NS)) {
            return true;
        }
        if (string.equals(FEATURE_NSPREFIXES)) {
            return this.saxout.nsPrefixes;
        }
        throw new SAXNotSupportedException(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals(FEATURE_NS)) {
            if (!bl) {
                throw new SAXNotSupportedException(string);
            }
        } else if (string.equals(FEATURE_NSPREFIXES)) {
            this.saxout.nsPrefixes = bl;
        } else {
            throw new SAXNotSupportedException(string);
        }
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals(PROPERTY_LEXICAL)) {
            this.saxout.setLexicalHandler((LexicalHandler)object);
        }
        throw new SAXNotSupportedException(string);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals(PROPERTY_LEXICAL)) {
            return this.saxout.getLexicalHandler();
        }
        throw new SAXNotSupportedException(string);
    }

    void execute(FONIDocument fONIDocument) throws IOException, SAXException {
        if (this.query == null) {
            throw new IllegalArgumentException("no query set");
        }
        if (fONIDocument != null) {
            this.input = new SingleNode(new FONIDataModel(fONIDocument).getDocumentNode());
        }
        try {
            this.executeQuery(this.query, this.saxout);
        }
        catch (XQueryException xQueryException) {
            SAXParseException sAXParseException = new SAXParseException(xQueryException.getMessage(), null, (Exception)xQueryException.getCause());
            if (this.saxout.getErrorHandler() != null) {
                this.saxout.getErrorHandler().fatalError(sAXParseException);
            }
            throw sAXParseException;
        }
    }
}

