/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dm;

import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.dm.XMLEventReceiverBase;
import net.xfra.qizxopen.util.LimitReachedException;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.dm.CoreDataModel;
import net.xfra.qizxopen.xquery.dm.Node;

public class EventDrivenBuilder
extends XMLEventReceiverBase {
    CoreDataModel.SNode root;
    CoreDataModel.Element current;
    CoreDataModel.SNode previous;
    int orderStamp = 1;

    public Node crop() {
        return this.root;
    }

    public String resolvePrefix(String string) {
        return this.current == null ? null : this.current.getNsUri(string);
    }

    public void reset() {
        this.current = null;
        this.root = null;
        this.previous = null;
    }

    public void terminate() {
    }

    public void startDocument() throws DataModelException {
        if (this.root != null) {
            throw new DataModelException("document inside document");
        }
        this.current = CoreDataModel.newDocumentNode();
        this.root = this.current;
        this.previous = null;
    }

    public void endDocument() throws DataModelException {
        this.closeNode();
    }

    public void startElement(QName qName) throws DataModelException {
        if (this.maxVolume > 0L && this.volume > this.maxVolume) {
            throw new LimitReachedException("volume limit reached");
        }
        CoreDataModel.Element element = CoreDataModel.newElement(qName);
        this.openNode(element);
    }

    public void endElement(QName qName) throws DataModelException {
        if (this.maxVolume > 0L && this.volume > this.maxVolume) {
            throw new LimitReachedException("volume limit reached");
        }
        this.closeNode();
    }

    public void namespace(String string, String string2) throws DataModelException {
        if (this.current == null) {
            throw new DataModelException("stray namespace");
        }
        CoreDataModel.NSNode nSNode = CoreDataModel.newNSNode(string);
        nSNode.value = string2;
        this.addAttribute(nSNode);
        this.volume += (long)string2.length();
    }

    public void attribute(QName qName, String string) throws DataModelException {
        if (this.maxVolume > 0L && this.volume > this.maxVolume) {
            throw new LimitReachedException("volume limit reached");
        }
        if (this.current == null) {
            throw new DataModelException("stray attribute");
        }
        CoreDataModel.Attribute attribute = CoreDataModel.newAttribute(qName);
        attribute.value = string;
        this.addAttribute(attribute);
        this.volume += (long)string.length();
    }

    public void text(String string) throws DataModelException {
        if (this.maxVolume > 0L && this.volume > this.maxVolume) {
            throw new LimitReachedException("volume limit reached");
        }
        if (this.previous != null && this.previous.getNature() == 7) {
            this.previous.addText(string);
        } else {
            this.addNode(new CoreDataModel.TextNode(string));
        }
        this.spaceNeeded = false;
        this.volume += (long)string.length();
    }

    public void atom(String string) throws DataModelException {
        if (this.maxVolume > 0L && this.volume > this.maxVolume) {
            throw new LimitReachedException("volume limit reached");
        }
        if (this.previous != null && this.previous.getNature() == 7) {
            if (this.spaceNeeded) {
                this.previous.addText(" ");
            }
            this.previous.addText(string);
        } else {
            this.addNode(new CoreDataModel.TextNode(string));
        }
        this.spaceNeeded = true;
        this.volume += (long)string.length();
    }

    public void pi(String string, String string2) throws DataModelException {
        if (this.maxVolume > 0L && this.volume > this.maxVolume) {
            throw new LimitReachedException("volume limit reached");
        }
        CoreDataModel.PINode pINode = new CoreDataModel.PINode(string, string2);
        this.addNode(pINode);
        this.volume += (long)string2.length();
    }

    public void comment(String string) throws DataModelException {
        if (this.maxVolume > 0L && this.volume > this.maxVolume) {
            throw new LimitReachedException("volume limit reached");
        }
        CoreDataModel.CommentNode commentNode = new CoreDataModel.CommentNode(string);
        this.addNode(commentNode);
        this.volume += (long)string.length();
    }

    private void addNode(CoreDataModel.SNode sNode) throws DataModelException {
        sNode.parent = this.current;
        if (this.previous != null) {
            this.previous.setNextSibling(sNode);
        } else if (this.current == null) {
            if (this.root != null) {
                throw new DataModelException("adding node after root");
            }
            this.current = (CoreDataModel.Element)sNode;
            this.root = this.current;
        } else {
            this.current.firstChild = sNode;
        }
        this.previous = sNode;
        sNode.order = this.orderStamp++;
    }

    private void openNode(CoreDataModel.Element element) throws DataModelException {
        this.addNode(element);
        this.current = element;
        this.previous = null;
        this.volume += 10L;
    }

    private void closeNode() throws DataModelException {
        if (this.current == null) {
            if (this.maxVolume > 0L && this.volume > this.maxVolume) {
                return;
            }
            throw new DataModelException("no open element");
        }
        this.previous = this.current;
        this.current = this.current.parent;
        this.volume += 10L;
    }

    private void addAttribute(CoreDataModel.Attribute attribute) throws DataModelException {
        if (this.current.getFirstChild() != null) {
            throw new DataModelException("attribute added after contents");
        }
        this.current.addAttribute(attribute);
        attribute.order = this.orderStamp++;
        this.volume += 10L;
    }

    public void flushElement(boolean bl) {
    }
}

