/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import java.util.Vector;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.dt.GenericValue;

public class ArraySequence
extends GenericValue {
    protected Object[] items;
    protected int size;
    protected int index = -1;
    protected Vector overflow;
    static final int MAX_BLOCK_SIZE = 65536;

    public ArraySequence(Object[] objectArray, int n) {
        this.items = objectArray;
        this.size = n;
    }

    public ArraySequence(int n) {
        this.items = new Object[n];
        this.size = 0;
    }

    public Value bornAgain() {
        return new ArraySequence(this.items, this.size);
    }

    public int getSize() {
        return this.size;
    }

    public void addItem(Item item) {
        if (this.size >= this.items.length) {
            if (this.items.length < 65536) {
                Object[] objectArray = this.items;
                this.items = new Object[objectArray.length * 2];
                System.arraycopy(objectArray, 0, this.items, 0, objectArray.length);
            } else {
                if (this.overflow == null) {
                    this.overflow = new Vector();
                }
                this.overflow.add(this.items);
                this.items = new Object[this.items.length];
                this.size = 0;
            }
        }
        this.items[this.size++] = item;
    }

    public void addItems(Item[] itemArray, int n) {
        if (this.size + n >= this.items.length) {
            int n2 = 0;
            while (n2 < n) {
                this.addItem(itemArray[n2]);
                ++n2;
            }
        } else {
            System.arraycopy(itemArray, 0, this.items, this.size, n);
            this.size += n;
        }
    }

    public void pack() {
        if (this.overflow == null) {
            return;
        }
        int n = this.overflow.size() * this.items.length + this.size;
        Object[] objectArray = new Object[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.overflow.size()) {
            System.arraycopy((Object[])this.overflow.get(n3), 0, objectArray, n2, this.items.length);
            n2 += this.items.length;
            ++n3;
        }
        System.arraycopy(this.items, 0, objectArray, n2, this.size);
        this.items = objectArray;
        this.size = n;
        this.overflow = null;
        this.reset();
    }

    public boolean next() throws XQueryException {
        if (this.overflow != null) {
            this.pack();
        }
        if (this.index >= this.size - 1) {
            return false;
        }
        this.item = (Item)this.items[++this.index];
        return true;
    }

    public long quickCount(EvalContext evalContext) throws XQueryException {
        int n = this.overflow != null ? this.overflow.size() : 0;
        return n * this.items.length + this.size;
    }

    public void reset() {
        this.index = -1;
    }

    public Item asItem() throws TypeException {
        return this.item;
    }

    public boolean notWorthExpanding() {
        return true;
    }

    public static Node[] expandNodes(Value value) throws XQueryException {
        Node[] nodeArray;
        Node[] nodeArray2 = new Node[8];
        int n = 0;
        while (value.next()) {
            if (n >= nodeArray2.length) {
                nodeArray = nodeArray2;
                nodeArray2 = new Node[nodeArray.length * 2];
                System.arraycopy(nodeArray, 0, nodeArray2, 0, nodeArray.length);
            }
            nodeArray2[n++] = value.asNode();
        }
        nodeArray = new Node[n];
        System.arraycopy(nodeArray2, 0, nodeArray, 0, n);
        return nodeArray;
    }
}

