/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import java.math.BigDecimal;
import java.text.Collator;
import net.xfra.qizxopen.xquery.EmptyException;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.dt.UntypedAtomicType;

public abstract class BaseValue
implements Value {
    protected ItemType itemType;

    public boolean nextCollection() throws XQueryException {
        return this.next();
    }

    public ItemType getType() {
        return this.itemType;
    }

    public Item asAtom() throws TypeException {
        return this.asItem();
    }

    public boolean asBoolean() throws TypeException {
        throw new TypeException(this.getClass().getName() + " not castable to boolean");
    }

    public long asInteger() throws TypeException {
        throw new TypeException(this.getClass().getName() + " not castable to integer");
    }

    public BigDecimal asDecimal() throws TypeException {
        throw new TypeException(this.getClass().getName() + " not castable to decimal");
    }

    public float asFloat() throws TypeException {
        throw new TypeException(this.getClass().getName() + " not castable to float");
    }

    public double asDouble() throws TypeException {
        throw new TypeException(this.getClass().getName() + " not castable to double");
    }

    public String asString() throws TypeException {
        throw new TypeException(this.getClass().getName() + " not castable to string");
    }

    public Node asNode() throws TypeException {
        TypeException typeException = new TypeException(this.getClass().getName() + " not castable to node");
        throw typeException;
    }

    public boolean isNode() {
        return false;
    }

    public int compareTo(Item item, Collator collator, int n) throws TypeException {
        return UntypedAtomicType.comparison(this, item, collator);
    }

    public boolean deepEqual(Item item, Collator collator) {
        return this.equals(item);
    }

    public boolean worthExpanding() {
        return true;
    }

    public void setLazy(boolean bl) {
    }

    public long quickCount(EvalContext evalContext) throws XQueryException {
        try {
            this.setLazy(true);
            long l = 0L;
            while (this.next()) {
                if ((l & 0x1FL) == 0L) {
                    evalContext.at(null);
                }
                ++l;
            }
            return l;
        }
        catch (EmptyException emptyException) {
            return 0L;
        }
    }
}

