/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.util.Namespace;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dt.IntegerArraySequence;
import net.xfra.qizxopen.xquery.dt.SingleInteger;
import net.xfra.qizxopen.xquery.dt.UnsignedIntType;
import net.xfra.qizxopen.xquery.op.Expression;

public class CharType
extends UnsignedIntType {
    public QName getName() {
        return QName.get(Namespace.XDT, this.getShortName());
    }

    public String toString() {
        return "xdt:char";
    }

    public String getShortName() {
        return "char";
    }

    public boolean accepts(Type type) {
        return Type.INTEGER.accepts(type);
    }

    public Value convertFromObject(Object object) {
        return new SingleInteger(((Character)object).charValue(), Type.CHAR);
    }

    public Object convertToObject(Expression expression, Focus focus, EvalContext evalContext) throws XQueryException {
        return new Character((char)expression.evalAsInteger(focus, evalContext));
    }

    public Value convertFromArray(Object object) {
        char[] cArray = (char[])object;
        return new IntegerArraySequence(cArray, cArray.length);
    }

    public Object convertToArray(Value value) throws XQueryException {
        return IntegerArraySequence.expandChars(value);
    }
}

