/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.xfra.qizxopen.xquery.TypeException;

public class Conversion {
    static double MAX_INTVALUE = 4.611686018427388E18;
    static double MIN_INTVALUE = -MAX_INTVALUE;
    static DecimalFormatSymbols syms = new DecimalFormatSymbols(Locale.US);
    static DecimalFormat fmtSciD = new DecimalFormat("0.0################E0##", syms);
    static DecimalFormat fmtDecD = new DecimalFormat("#####0.0################", syms);
    static DecimalFormat fmtSciF = new DecimalFormat("0.0########E0##", syms);
    static DecimalFormat fmtDecF = new DecimalFormat("#####0.0########", syms);

    public static boolean toBoolean(double d) {
        return d != 0.0 && d == d;
    }

    public static boolean toBoolean(String string) {
        return string.length() > 0;
    }

    public static long toInteger(boolean bl) {
        return bl ? 1L : 0L;
    }

    public static long toInteger(String string) throws TypeException {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TypeException("invalid integer value " + string);
        }
    }

    public static boolean isIntegerRange(double d) {
        return d >= MIN_INTVALUE && d < MAX_INTVALUE;
    }

    public static float toFloat(boolean bl) {
        return bl ? 1.0f : 0.0f;
    }

    public static float toFloat(String string) throws TypeException {
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TypeException("invalid float value " + string);
        }
    }

    public static double toDouble(boolean bl) {
        return bl ? 1.0 : 0.0;
    }

    public static double toDouble(String string) throws TypeException {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TypeException("invalid double value " + string);
        }
    }

    public static BigDecimal toDecimal(boolean bl) {
        return new BigDecimal(bl ? 1.0 : 0.0);
    }

    public static BigDecimal toDecimal(long l) {
        return new BigDecimal(Long.toString(l));
    }

    public static BigDecimal toDecimal(String string) throws TypeException {
        try {
            return new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TypeException("invalid decimal value " + string);
        }
    }

    public static String toString(boolean bl) {
        return bl ? "true" : "false";
    }

    public static String toString(long l) throws TypeException {
        return Long.toString(l);
    }

    public static String toString(float f) throws TypeException {
        int n;
        String string;
        if (f == 0.0f) {
            return "0";
        }
        if (Float.isInfinite(f)) {
            return f < 0.0f ? "-INF" : "INF";
        }
        if (f != f) {
            return "NaN";
        }
        float f2 = Math.abs(f);
        String string2 = null;
        if (f2 >= 1.0E-6f && f2 < 1000000.0f) {
            string = fmtDecF.format(f);
        } else {
            string = fmtSciF.format(f);
            n = string.indexOf(69);
            if (n > 0) {
                string2 = string.substring(n + 1, string.length());
                string = string.substring(0, n);
            }
        }
        if (string.indexOf(46) >= 0) {
            n = string.length();
            while (n > 0 && string.charAt(n - 1) == '0') {
                --n;
            }
            if (n > 0 && string.charAt(n - 1) == '.') {
                --n;
            }
            string = string.substring(0, n);
        }
        return string2 == null ? string : string.concat("E").concat(string2);
    }

    public static String toString(double d) throws TypeException {
        int n;
        String string;
        if (d == 0.0) {
            return "0";
        }
        if (Double.isInfinite(d)) {
            return d < 0.0 ? "-INF" : "INF";
        }
        if (d != d) {
            return "NaN";
        }
        double d2 = Math.abs(d);
        String string2 = null;
        if (d2 >= 1.0E-6 && d2 < 1000000.0) {
            string = fmtDecD.format(d);
        } else {
            string = fmtSciD.format(d);
            n = string.indexOf(69);
            if (n > 0) {
                string2 = string.substring(n + 1, string.length());
                string = string.substring(0, n);
            }
        }
        n = string.length();
        if (n > 2 && string.charAt(n - 1) == '0' && string.charAt(n - 2) == '.') {
            string = string.substring(0, n - 2);
        }
        return string2 == null ? string : string.concat("E").concat(string2);
    }
}

