/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import java.math.BigDecimal;
import java.text.Collator;
import net.xfra.qizxopen.util.Util;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.dt.BaseValue;

public abstract class DecimalValue
extends BaseValue {
    public DecimalValue() {
        this.itemType = Type.DECIMAL;
    }

    public abstract BigDecimal getValue();

    public Item asItem() {
        return this;
    }

    public String asString() throws TypeException {
        String string = this.getValue().toString();
        int n = string.length();
        while (--n >= 0) {
            if (string.charAt(n) != '0') break;
        }
        if (n < 0 || string.charAt(n) == '.') {
            --n;
        }
        return string.substring(0, n + 1);
    }

    public double asDouble() throws TypeException {
        return this.getValue().doubleValue();
    }

    public float asFloat() throws TypeException {
        return this.getValue().floatValue();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DecimalValue)) {
            return false;
        }
        return this.getValue().equals(((DecimalValue)object).getValue());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public int compareTo(Item item, Collator collator, int n) throws TypeException {
        if (Type.UNTYPED_ATOMIC.accepts(item.getType())) {
            return Util.comparison(this.asDouble() - item.asDouble());
        }
        if (!Type.NUMERIC.accepts(item.getType())) {
            return 2;
        }
        if (item.getType() == Type.DECIMAL) {
            return this.getValue().compareTo(((DecimalValue)item).getValue());
        }
        return this.getValue().compareTo(new BigDecimal(item.asDouble()));
    }
}

