/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dt.FloatArraySequence;
import net.xfra.qizxopen.xquery.dt.NumericType;
import net.xfra.qizxopen.xquery.dt.SingleDouble;
import net.xfra.qizxopen.xquery.op.Expression;

public class DoubleType
extends NumericType {
    public String getShortName() {
        return "double";
    }

    public boolean accepts(Type type) {
        return Type.NUMERIC.accepts(type);
    }

    public Value cast(Value value, EvalContext evalContext) throws TypeException {
        try {
            return new SingleDouble(value.asDouble());
        }
        catch (TypeException typeException) {
            throw new TypeException("cannot cast to xs:double: " + typeException.getMessage());
        }
    }

    public Value convertFromObject(Object object) {
        return new SingleDouble((Double)object);
    }

    public Object convertToObject(Expression expression, Focus focus, EvalContext evalContext) throws XQueryException {
        return new Double(expression.evalAsDouble(focus, evalContext));
    }

    public Value convertFromArray(Object object) {
        double[] dArray = (double[])object;
        return new FloatArraySequence(dArray, dArray.length);
    }

    public Object convertToArray(Value value) throws XQueryException {
        return FloatArraySequence.expandDoubles(value);
    }
}

