/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import java.text.Collator;
import net.xfra.qizxopen.util.Util;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.dt.BaseValue;
import net.xfra.qizxopen.xquery.dt.Conversion;
import net.xfra.qizxopen.xquery.dt.SingleFloat;

public abstract class FloatValue
extends BaseValue {
    public FloatValue() {
        this.itemType = Type.FLOAT;
    }

    public Item asItem() throws TypeException {
        return new SingleFloat(this.asFloat());
    }

    public boolean asBoolean() throws TypeException {
        float f = this.asFloat();
        return f == f && f != 0.0f;
    }

    public long asInteger() throws TypeException {
        return Math.round(this.asFloat());
    }

    public double asDouble() throws TypeException {
        return this.asFloat();
    }

    public String asString() throws TypeException {
        return Conversion.toString(this.asFloat());
    }

    public boolean equals(Object object) {
        if (!(object instanceof Item)) {
            return false;
        }
        try {
            Item item = (Item)object;
            return item.getType() == Type.FLOAT && this.asFloat() == item.asFloat();
        }
        catch (TypeException typeException) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return Float.floatToIntBits(this.asFloat());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int compareTo(Item item, Collator collator, int n) throws TypeException {
        if (!Type.DOUBLE.accepts(item.getType())) {
            return 2;
        }
        return Util.comparison(this.asDouble() - item.asDouble());
    }
}

