/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.util.time.DateTimeException;
import net.xfra.qizxopen.util.time.GDay;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.dt.MomentType;
import net.xfra.qizxopen.xquery.dt.MomentValue;
import net.xfra.qizxopen.xquery.dt.SingleMoment;
import net.xfra.qizxopen.xquery.dt.StringType;

public class GDayType
extends MomentType {
    public String getShortName() {
        return "gDay";
    }

    public Value cast(Value value, EvalContext evalContext) throws TypeException {
        GDay gDay;
        block5: {
            ItemType itemType = value.getType();
            gDay = null;
            try {
                if (itemType instanceof StringType) {
                    gDay = GDay.parseGDay(value.asString());
                    break block5;
                }
                if (Type.INTEGER.accepts(itemType)) {
                    gDay = new GDay((int)value.asInteger(), 0, 0, 0);
                    break block5;
                }
                if (itemType == Type.DATE || itemType == Type.DATE_TIME) {
                    gDay = new GDay(((MomentValue)value.asItem()).getValue());
                    break block5;
                }
                throw new DateTimeException("invalid type " + itemType);
            }
            catch (DateTimeException dateTimeException) {
                throw new TypeException("cannot cast to xs:gDay : " + dateTimeException.getMessage());
            }
        }
        return new SingleMoment(gDay, Type.G_DAY);
    }
}

