/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dt.IntegerArraySequence;
import net.xfra.qizxopen.xquery.dt.LongType;
import net.xfra.qizxopen.xquery.dt.SingleInteger;
import net.xfra.qizxopen.xquery.op.Expression;

public class IntType
extends LongType {
    public String getShortName() {
        return "int";
    }

    protected long upperBound() {
        return Integer.MAX_VALUE;
    }

    protected long lowerBound() {
        return Integer.MIN_VALUE;
    }

    public Value convertFromObject(Object object) {
        return new SingleInteger(((Integer)object).intValue(), Type.INT);
    }

    public Object convertToObject(Expression expression, Focus focus, EvalContext evalContext) throws XQueryException {
        return new Integer((int)expression.evalAsInteger(focus, evalContext));
    }

    public Value convertFromArray(Object object) {
        int[] nArray = (int[])object;
        return new IntegerArraySequence(nArray, nArray.length);
    }

    public Object convertToArray(Value value) throws XQueryException {
        return IntegerArraySequence.expandInts(value);
    }
}

