/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dt.GenericValue;
import net.xfra.qizxopen.xquery.dt.SingleInteger;

public class IntegerArraySequence
extends GenericValue {
    protected long[] items;
    protected int size;
    protected int index = -1;

    public IntegerArraySequence(long[] lArray, int n) {
        this.items = lArray;
        this.size = n;
    }

    public IntegerArraySequence(int[] nArray, int n) {
        long[] lArray = new long[n];
        int n2 = n;
        while (--n2 >= 0) {
            lArray[n2] = nArray[n2];
        }
        this.items = lArray;
        this.size = n;
    }

    public IntegerArraySequence(short[] sArray, int n) {
        long[] lArray = new long[n];
        int n2 = n;
        while (--n2 >= 0) {
            lArray[n2] = sArray[n2];
        }
        this.items = lArray;
        this.size = n;
    }

    public IntegerArraySequence(byte[] byArray, int n) {
        long[] lArray = new long[n];
        int n2 = n;
        while (--n2 >= 0) {
            lArray[n2] = byArray[n2];
        }
        this.items = lArray;
        this.size = n;
    }

    public IntegerArraySequence(char[] cArray, int n) {
        long[] lArray = new long[n];
        int n2 = n;
        while (--n2 >= 0) {
            lArray[n2] = cArray[n2];
        }
        this.items = lArray;
        this.size = n;
    }

    public boolean next() throws XQueryException {
        if (++this.index >= this.size) {
            return false;
        }
        this.item = new SingleInteger(this.items[this.index]);
        return true;
    }

    public Value bornAgain() {
        return new IntegerArraySequence(this.items, this.size);
    }

    static long[] unroll(Value value) throws XQueryException {
        long[] lArray = new long[8];
        int n = 1;
        while (value.next()) {
            if (n >= lArray.length) {
                long[] lArray2 = lArray;
                lArray = new long[lArray2.length * 2];
                System.arraycopy(lArray2, 0, lArray, 0, lArray2.length);
            }
            lArray[n++] = value.asInteger();
        }
        lArray[0] = n - 1;
        return lArray;
    }

    public static long[] expandIntegers(Value value) throws XQueryException {
        long[] lArray = IntegerArraySequence.unroll(value);
        int n = (int)lArray[0];
        long[] lArray2 = new long[n];
        System.arraycopy(lArray, 1, lArray2, 0, n);
        return lArray2;
    }

    public static int[] expandInts(Value value) throws XQueryException {
        long[] lArray = IntegerArraySequence.unroll(value);
        int n = (int)lArray[0];
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = (int)lArray[n2 + 1];
            ++n2;
        }
        return nArray;
    }

    public static short[] expandShorts(Value value) throws XQueryException {
        long[] lArray = IntegerArraySequence.unroll(value);
        int n = (int)lArray[0];
        short[] sArray = new short[n];
        int n2 = 0;
        while (n2 < n) {
            sArray[n2] = (short)lArray[n2 + 1];
            ++n2;
        }
        return sArray;
    }

    public static byte[] expandBytes(Value value) throws XQueryException {
        long[] lArray = IntegerArraySequence.unroll(value);
        int n = (int)lArray[0];
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)lArray[n2 + 1];
            ++n2;
        }
        return byArray;
    }

    public static char[] expandChars(Value value) throws XQueryException {
        long[] lArray = IntegerArraySequence.unroll(value);
        int n = (int)lArray[0];
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = (char)lArray[n2 + 1];
            ++n2;
        }
        return cArray;
    }
}

