/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import java.text.Collator;
import net.xfra.qizxopen.util.Util;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.dt.BaseValue;
import net.xfra.qizxopen.xquery.dt.Conversion;
import net.xfra.qizxopen.xquery.dt.SingleInteger;

public abstract class IntegerValue
extends BaseValue {
    public IntegerValue() {
        this.itemType = Type.INTEGER;
    }

    public Item asItem() throws TypeException {
        return new SingleInteger(this.asInteger(), this.itemType);
    }

    public boolean asBoolean() throws TypeException {
        return this.asInteger() != 0L;
    }

    public double asDouble() throws TypeException {
        return this.asInteger();
    }

    public float asFloat() throws TypeException {
        return this.asInteger();
    }

    public String asString() throws TypeException {
        return Conversion.toString(this.asInteger());
    }

    public boolean equals(Object object) {
        if (!(object instanceof Item)) {
            return false;
        }
        try {
            return this.asInteger() == ((Item)object).asInteger();
        }
        catch (TypeException typeException) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return (int)this.asInteger();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int compareTo(Item item, Collator collator, int n) throws TypeException {
        if (!Type.DOUBLE.accepts(item.getType())) {
            return 2;
        }
        return Util.comparison(this.asDouble() - item.asDouble());
    }
}

