/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dt.GenericValue;
import net.xfra.qizxopen.xquery.dt.SingleString;

public class StringArraySequence
extends GenericValue {
    protected String[] items;
    protected int size;
    protected int index = -1;

    public StringArraySequence(String[] stringArray, int n) {
        this.items = stringArray;
        this.size = n;
    }

    public boolean next() throws XQueryException {
        if (++this.index >= this.size) {
            return false;
        }
        this.item = new SingleString(this.items[this.index]);
        return true;
    }

    public Value bornAgain() {
        return new StringArraySequence(this.items, this.size);
    }

    public static String[] expand(Value value) throws XQueryException {
        String[] stringArray;
        String[] stringArray2 = new String[8];
        int n = 0;
        while (value.next()) {
            if (n >= stringArray2.length) {
                stringArray = stringArray2;
                stringArray2 = new String[stringArray.length * 2];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            }
            stringArray2[n++] = value.asString();
        }
        stringArray = new String[n];
        System.arraycopy(stringArray2, 0, stringArray, 0, n);
        return stringArray;
    }
}

