/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.util.time.DateTimeException;
import net.xfra.qizxopen.util.time.Time;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.dt.MomentType;
import net.xfra.qizxopen.xquery.dt.MomentValue;
import net.xfra.qizxopen.xquery.dt.NodeType;
import net.xfra.qizxopen.xquery.dt.SingleMoment;
import net.xfra.qizxopen.xquery.dt.StringType;

public class TimeType
extends MomentType {
    public String getShortName() {
        return "time";
    }

    public Value cast(Value value, EvalContext evalContext) throws TypeException {
        Time time;
        block4: {
            ItemType itemType = value.getType();
            time = null;
            try {
                if (itemType instanceof StringType || itemType instanceof NodeType) {
                    time = Time.parseTime(value.asString(), evalContext.getImplicitTimezone());
                    break block4;
                }
                if (itemType == Type.TIME || itemType == Type.DATE_TIME) {
                    time = new Time(((MomentValue)value.asItem()).getValue());
                    break block4;
                }
                throw new DateTimeException("invalid type " + itemType);
            }
            catch (DateTimeException dateTimeException) {
                throw new TypeException("cannot cast to xs:time : " + dateTimeException.getMessage());
            }
        }
        return new SingleMoment(time, Type.TIME);
    }
}

