/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import net.xfra.qizxopen.util.Namespace;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dt.AtomicType;
import net.xfra.qizxopen.xquery.dt.ObjectArraySequence;
import net.xfra.qizxopen.xquery.dt.SingleItem;
import net.xfra.qizxopen.xquery.dt.SingleWrappedObject;
import net.xfra.qizxopen.xquery.dt.StringValue;
import net.xfra.qizxopen.xquery.dt.WrappedObjectValue;
import net.xfra.qizxopen.xquery.op.Expression;

public class WrappedObjectType
extends AtomicType {
    Class classe;

    public WrappedObjectType(Class clazz) {
        this.classe = clazz;
        this.parent = Type.ATOM;
    }

    public QName getName() {
        return QName.get(Namespace.XDT, this.getShortName());
    }

    public String toString() {
        return "xdt:object[" + this.classe.getName() + "]";
    }

    public String getShortName() {
        return "object";
    }

    public boolean accepts(Type type) {
        ItemType itemType = type.getItemType();
        if (!(itemType instanceof WrappedObjectType) || itemType == Type.OBJECT) {
            return true;
        }
        WrappedObjectType wrappedObjectType = (WrappedObjectType)itemType;
        return this.classe.isAssignableFrom(wrappedObjectType.classe);
    }

    public Value convertFromObject(Object object) {
        if (object instanceof Item) {
            return new SingleItem((Item)object);
        }
        return object == null ? Value.empty : new SingleWrappedObject(object);
    }

    public Object convertToObject(Expression expression, Focus focus, EvalContext evalContext) throws XQueryException {
        Item item = expression.evalAsItem(focus, evalContext);
        if (item instanceof StringValue) {
            return item.asString();
        }
        if (item instanceof WrappedObjectValue) {
            return ((WrappedObjectValue)item).getObject();
        }
        return item;
    }

    public Value convertFromArray(Object object) {
        if (object instanceof Enumeration) {
            return new ObjectArraySequence((Enumeration)object);
        }
        if (object instanceof ArrayList) {
            return new ObjectArraySequence((ArrayList)object);
        }
        if (object instanceof Vector) {
            return new ObjectArraySequence((Vector)object);
        }
        if (object == null) {
            return Value.empty;
        }
        Object[] objectArray = (Object[])object;
        return new ObjectArraySequence(objectArray, objectArray.length);
    }

    public Object convertToArray(Value value) throws XQueryException {
        return ObjectArraySequence.expand(value);
    }
}

