/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.fn;

import net.xfra.qizxopen.util.time.DateTimeBase;
import net.xfra.qizxopen.util.time.Duration;
import net.xfra.qizxopen.util.time.Time;
import net.xfra.qizxopen.xquery.EmptyException;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dt.DurationValue;
import net.xfra.qizxopen.xquery.dt.MomentValue;
import net.xfra.qizxopen.xquery.dt.SingleMoment;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;

public class AdjustToTimezone
extends Function {
    static Prototype[] protos = new Prototype[]{Prototype.fn("adjust-to-timezone", Type.TIME.opt, class$net$xfra$qizxopen$xquery$fn$AdjustToTimezone$Exec == null ? (class$net$xfra$qizxopen$xquery$fn$AdjustToTimezone$Exec = AdjustToTimezone.class$("net.xfra.qizxopen.xquery.fn.AdjustToTimezone$Exec")) : class$net$xfra$qizxopen$xquery$fn$AdjustToTimezone$Exec).arg("val", (Type)Type.TIME.opt).arg("timezone", (Type)Type.DURATION.opt), Prototype.fn("adjust-to-timezone", Type.DATE_TIME.opt, class$net$xfra$qizxopen$xquery$fn$AdjustToTimezone$Exec == null ? (class$net$xfra$qizxopen$xquery$fn$AdjustToTimezone$Exec = AdjustToTimezone.class$("net.xfra.qizxopen.xquery.fn.AdjustToTimezone$Exec")) : class$net$xfra$qizxopen$xquery$fn$AdjustToTimezone$Exec).arg("val", (Type)Type.DATE_TIME.opt).arg("timezone", (Type)Type.DURATION.opt), Prototype.fn("adjust-to-timezone", Type.DATE.opt, class$net$xfra$qizxopen$xquery$fn$AdjustToTimezone$Exec == null ? (class$net$xfra$qizxopen$xquery$fn$AdjustToTimezone$Exec = AdjustToTimezone.class$("net.xfra.qizxopen.xquery.fn.AdjustToTimezone$Exec")) : class$net$xfra$qizxopen$xquery$fn$AdjustToTimezone$Exec).arg("val", (Type)Type.DATE.opt).arg("timezone", (Type)Type.DURATION.opt)};
    static /* synthetic */ Class class$net$xfra$qizxopen$xquery$fn$AdjustToTimezone$Exec;

    public Prototype[] getProtos() {
        return protos;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Exec
    extends Function.Call {
        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            evalContext.at(this);
            Item item = this.args[0].evalAsOptItem(focus, evalContext);
            Item item2 = this.args[1].evalAsItem(focus, evalContext);
            if (item == null) {
                throw EmptyException.allowed();
            }
            DateTimeBase dateTimeBase = ((MomentValue)item).getValue();
            Duration duration = ((DurationValue)item2).getValue();
            if (!duration.checkAsTimezone()) {
                evalContext.error(this.args[1], "invalid timezone value");
            }
            int n = (int)(duration.getSeconds() / 60.0);
            DateTimeBase dateTimeBase2 = dateTimeBase.adjustToTimezone(n);
            try {
                if (item.getType() == Type.TIME) {
                    dateTimeBase2 = new Time(dateTimeBase2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return new SingleMoment(dateTimeBase2, item.getType());
        }
    }
}

